/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens;

import org.mule.tooling.core.MuleCorePlugin;

public enum Operator {
    UNKNOWN_OP("unknown", 20),
    DOT(".", 15),
    QUESTION_MARK_DOT(".?", 15),
    INCREMENT("++", 14),
    DECREMENT("--", 14),
    TILDE("~", 13),
    EXCLAMATION("!", 13),
    PERCENTAGE("%", 12),
    DIVISION("/", 12),
    MULTIPLICATION("*", 12),
    PLUS("+", 11),
    MINUS("-", 11),
    LESS_THAN("<", 9),
    GREATER_THAN(">", 9),
    LESS_EQUALS("<=", 9),
    GREAT_EQUALS(">=", 9),
    EQUAL_EQUAL("==", 8),
    DIFFERENT("!=", 8),
    AMPERSAND("&", 7),
    CARET("^", 6),
    PIPE("|", 5),
    AND("&&", 4),
    OR("||", 3),
    QUESTION_MARK("?", 2),
    COLON(":", 2),
    EQUAL("=", 1),
    NEW("new", 14),
    COMMA(",", 15),
    SEMICOLON(";", 0);

    private final String operatorStr;
    private final int precedence;

    private Operator(String operatorStr, int precedence) {
        this.operatorStr = operatorStr;
        this.precedence = precedence;
    }

    public static Operator fromString(String string) {
        Operator[] operatorArray = Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Operator operator = operatorArray[n2];
            if (operator.operatorStr.equals(string)) {
                return operator;
            }
            ++n2;
        }
        String message = "No operator defined for string: \"" + string + "\"";
        MuleCorePlugin.logError((String)message, (Throwable)new IllegalArgumentException(message));
        return UNKNOWN_OP;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public String toString() {
        return this.operatorStr;
    }

    public static boolean containsOperator(String s) {
        Operator[] operatorArray = Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Operator operator = operatorArray[n2];
            if (s.contains(operator.toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

