/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens;

import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.ITokenVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.RichToken;

public class BracketToken
extends RichToken {
    private Bracket bracket;

    public BracketToken(Object data, Bracket bracket) {
        super(data);
        this.bracket = bracket;
    }

    public BracketToken(Object data, String bracketStr) {
        this(data, Bracket.fromString(bracketStr));
    }

    public Bracket getBracket() {
        return this.bracket;
    }

    @Override
    public void accept(ITokenVisitor visitor) {
        visitor.visitBracket(this);
    }

    public static enum Bracket {
        PARENTHESIS_OPEN("("),
        PARENTHESIS_CLOSE(")"),
        BRACKET_OPEN("["),
        BRACKET_CLOSE("]"),
        CURLY_BRACE_OPEN("{"),
        CURLY_BRACE_CLOSE("}");

        private String bracketStr;

        private Bracket(String bracketStr) {
            this.bracketStr = bracketStr;
        }

        public static Bracket fromString(String string) {
            Bracket[] bracketArray = Bracket.values();
            int n = bracketArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bracket bracket = bracketArray[n2];
                if (bracket.bracketStr.equals(string)) {
                    return bracket;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return this.bracketStr;
        }
    }
}

