/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel.scanner;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.MELScanner;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.OperatorToken;

public final class OperatorRule
implements IRule {
    private static final char[] OPERATORS = new char[]{';', '.', '=', '/', '+', '-', '*', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
    private static final char[] DOUBLE_OPERATORS = new char[]{'&', '|', '-', '+'};
    private static final char[] COMPARATORS = new char[]{'<', '>', '!', '='};

    private boolean isInArray(char character, char[] array) {
        int index = 0;
        while (index < array.length) {
            if (array[index] == character) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private boolean isOperator(char character) {
        return this.isInArray(character, OPERATORS);
    }

    private boolean isDoubleOperator(char character) {
        return this.isInArray(character, DOUBLE_OPERATORS);
    }

    private boolean isComparator(char character) {
        return this.isInArray(character, COMPARATORS);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        char character1 = (char)scanner.read();
        if (this.isOperator(character1)) {
            boolean isDoubleComparator;
            char character2 = (char)scanner.read();
            boolean isDoubleOperator = character2 == character1 && this.isDoubleOperator(character1);
            boolean bl = isDoubleComparator = this.isComparator(character1) && character2 == '=';
            if (isDoubleOperator || isDoubleComparator) {
                char[] chars = new char[]{character1, character2};
                return this.createOperatorToken(new String(chars));
            }
            scanner.unread();
            return this.createOperatorToken(character1);
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private OperatorToken createOperatorToken(char character) {
        return this.createOperatorToken(String.valueOf(character));
    }

    private OperatorToken createOperatorToken(String operatorStr) {
        return new OperatorToken((Object)new TextAttribute(MELScanner.REGULAR_COLOR), operatorStr);
    }
}

