/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel.scanner;

import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.BracketRule;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.DecimalNumberRule;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.OperatorRule;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.BracketToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.CommentToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.IdentifierToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Keyword;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.KeywordToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.NumberLiteralToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.StringLiteralToken;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class MELScanner
extends RuleBasedScanner {
    public static final Color STRING_COLOR = new Color(ThemeUtils.getCurrentTheme().getDFLStringColor());
    public static final Color COMMENT_COLOR = new Color(ThemeUtils.getCurrentTheme().getDFLCommentColor());
    public static final Color KEYWORD_COLOR = new Color(ThemeUtils.getCurrentTheme().getDFLKeywordColor());
    public static final Color NUMBER_COLOR = new Color(ThemeUtils.getCurrentTheme().getDFLNumberColor());
    public static final Color REGULAR_COLOR = ThemeUtils.getCurrentTheme().getForegroundColor();
    private static final String[] MEL_KEYWORDS = new String[]{"payload", "message", "server", "mule", "app", "flowVars", "sessionVars", "validator"};

    public MELScanner() {
        Keyword keyword;
        ArrayList<Object> rules = new ArrayList<Object>();
        CommentToken commentToken = new CommentToken(new TextAttribute(COMMENT_COLOR));
        StringLiteralToken stringToken = new StringLiteralToken(new TextAttribute(STRING_COLOR));
        NumberLiteralToken numberToken = new NumberLiteralToken(new TextAttribute(NUMBER_COLOR));
        IdentifierToken identifierToken = new IdentifierToken(new TextAttribute(REGULAR_COLOR));
        SingleLineRule singleLineCommentRule = new SingleLineRule("//", null, (IToken)commentToken, '\\', true);
        rules.add(singleLineCommentRule);
        rules.add(new MultiLineRule("/*", "*/", (IToken)commentToken, '\\'));
        rules.add(new SingleLineRule("\"", "\"", (IToken)stringToken, '\\', true));
        rules.add(new SingleLineRule("'", "'", (IToken)stringToken, '\\', true));
        rules.add(new DecimalNumberRule((IToken)numberToken));
        rules.add(new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        }));
        WordRule identifierAndKeywordsRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)identifierToken, true);
        Object[] objectArray = Keyword.values();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            keyword = objectArray[n2];
            KeywordToken keywordToken = new KeywordToken((Object)new TextAttribute(KEYWORD_COLOR, null, 1), keyword);
            identifierAndKeywordsRule.addWord(keyword.toString(), (IToken)keywordToken);
            ++n2;
        }
        objectArray = MEL_KEYWORDS;
        n = MEL_KEYWORDS.length;
        n2 = 0;
        while (n2 < n) {
            keyword = objectArray[n2];
            identifierAndKeywordsRule.addWord((String)((Object)keyword), (IToken)new IdentifierToken(new TextAttribute(KEYWORD_COLOR, null, 1)));
            ++n2;
        }
        rules.add(identifierAndKeywordsRule);
        rules.add(new OperatorRule());
        objectArray = BracketToken.Bracket.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Keyword bracket = objectArray[n2];
            BracketToken bracketToken = new BracketToken((Object)new TextAttribute(REGULAR_COLOR), (BracketToken.Bracket)((Object)bracket));
            BracketRule bracketRule = new BracketRule((IToken)bracketToken, ((BracketToken.Bracket)((Object)bracket)).toString());
            rules.add(bracketRule);
            ++n2;
        }
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }
}

