/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel.scanner;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class DecimalNumberRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IToken fToken;
    protected int fColumn = -1;

    public DecimalNumberRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (Character.isDigit((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            int dotFound = 0;
            do {
                if ((c = scanner.read()) != 46) continue;
                ++dotFound;
            } while (Character.isDigit((char)c) || c == 46 && dotFound >= 1);
            scanner.unread();
            return this.fToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

