/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.HashMap;
import java.util.Map;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FunctionDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MuleExpressionFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MulePayloadFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.VariablesFieldResolver;

public class MuleMessageFieldResolver
extends MuleExpressionFieldResolver {
    private Map<String, FieldDefinition> fields = new HashMap<String, FieldDefinition>();
    private Map<String, FunctionDefinition> methods = new HashMap<String, FunctionDefinition>();

    public MuleMessageFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        super(configurationRef);
    }

    @Override
    protected Map<String, FunctionDefinition> getMethodDefinitions() {
        if (this.methods.isEmpty()) {
            this.methods.put("payloadAs", new FunctionDefinition("payloadAs", new String[]{Class.class.getName()}, Object.class.getName(), "Applies a mule transformer to the payload that converts it to the specified class."));
        }
        return this.methods;
    }

    @Override
    protected Map<String, FieldDefinition> getFieldDefinitions() {
        if (this.fields.isEmpty()) {
            this.fields.put("id", new FieldDefinition("id", "id", "ID of the Mule message (read-only)", String.class.getName()));
            this.fields.put("rootId", new FieldDefinition("rootId", "rootId", "Root ID of the Mule message (read-only)", String.class.getName()));
            this.fields.put("correlationId", new FieldDefinition("correlationId", "correlationId", "Correlation ID of the Mule message (read-only)", String.class.getName()));
            this.fields.put("correlationSequence", new FieldDefinition("correlationSequence", "correlationSequence", "(read-only)", String.class.getName()));
            this.fields.put("correlationGroupSize", new FieldDefinition("correlationGroupSize", "correlationGroupSize", "(read-only)", String.class.getName()));
            this.fields.put("replyTo", new FieldDefinition("replyTo", "replyTo", "", String.class.getName()));
            this.fields.put("dataType", new FieldDefinition("dataType", "dataType", "(read-only)", String.class.getName()));
            this.fields.put("payload", new FieldDefinition("payload", "payload", "", null));
            this.fields.put("vars", new FieldDefinition("vars", "vars", "", Map.class.getName()));
            this.fields.put("inboundAttachments", new FieldDefinition("inboundAttachments", "inboundAttachments", "", Map.class.getName()));
            this.fields.put("outboundAttachments", new FieldDefinition("outboundAttachments", "outboundAttachments", "", Map.class.getName()));
            this.fields.put("exception", new FieldDefinition("exception", "exception", "(read-only)", "org.mule.runtime.core.internal.message.DefaultExceptionPayload"));
        }
        return this.fields;
    }

    @Override
    public FieldResolver getFieldResolver(String fieldName) {
        if ("payload".equals(fieldName)) {
            return new MulePayloadFieldResolver((IObjectRef<EvaluatorExtensionConfiguration>)this.configurationRef);
        }
        if ("vars".equals(fieldName)) {
            return new VariablesFieldResolver((IObjectRef<EvaluatorExtensionConfiguration>)this.configurationRef);
        }
        return super.getFieldResolver(fieldName);
    }
}

