/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IRegion;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.ClassInstanceFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FunctionDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.NullFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ProposalFactory;

public abstract class MuleExpressionFieldResolver
implements FieldResolver {
    protected IObjectRef<EvaluatorExtensionConfiguration> configurationRef;

    public MuleExpressionFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        this.configurationRef = configurationRef;
    }

    @Override
    public FieldResolver getFieldResolver(String fieldName) {
        if (this.getFieldDefinitions() != null && this.getFieldDefinitions().containsKey(fieldName)) {
            String type = this.getFieldDefinitions().get(fieldName).getType();
            return new ClassInstanceFieldResolver(this.configurationRef, type);
        }
        return NullFieldResolver.INSTANCE;
    }

    @Override
    public List<ComparableCompletionProposal> getFields(IRegion replacementRange, String lastWord) {
        ArrayList<ComparableCompletionProposal> result = new ArrayList<ComparableCompletionProposal>();
        if (this.getFieldDefinitions() != null) {
            Collection<FieldDefinition> values = this.getFieldDefinitions().values();
            for (FieldDefinition fieldDefinition : values) {
                if (!fieldDefinition.getName().startsWith(lastWord)) continue;
                result.add(ProposalFactory.createFieldProposal(fieldDefinition, replacementRange));
            }
        }
        return result;
    }

    @Override
    public List<ComparableCompletionProposal> getMethods(IRegion replacementRange, String lastWord) {
        ArrayList<ComparableCompletionProposal> result = new ArrayList<ComparableCompletionProposal>();
        if (this.getMethodDefinitions() != null) {
            Collection<FunctionDefinition> values = this.getMethodDefinitions().values();
            for (FunctionDefinition methodDefinition : values) {
                if (!methodDefinition.getName().startsWith(lastWord)) continue;
                result.add(ProposalFactory.createMethodProposal(methodDefinition, replacementRange));
            }
        }
        return result;
    }

    @Override
    public FieldResolver getMethodResolver(String name, MethodCallNode methodCall) {
        if (this.getMethodDefinitions() != null && this.getMethodDefinitions().containsKey(name)) {
            return new ClassInstanceFieldResolver(this.configurationRef, this.getMethodDefinitions().get(name).getReturnType());
        }
        return NullFieldResolver.INSTANCE;
    }

    protected abstract Map<String, FunctionDefinition> getMethodDefinitions();

    protected abstract Map<String, FieldDefinition> getFieldDefinitions();
}

