/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.ToolingPropagationInfo;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.metadata.datasense.DataSenseRequest;
import org.mule.tooling.metadata.datasense.DataSenseResponse;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.modules.core.api.metadata.IDataSenseResolver;

public class MetadataResolver {
    private IObjectRef<EvaluatorExtensionConfiguration> configurationRef;

    public MetadataResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        this.configurationRef = configurationRef;
    }

    public MetadataType resolvePayload() {
        return this.resolveMetadataEvent().getPayload();
    }

    public ObjectType resolveVariables() {
        return this.resolveMetadataEvent().getVariables();
    }

    public MetadataType resolveAttributes() {
        return this.resolveMetadataEvent().getAttributes();
    }

    private MetadataEvent resolveMetadataEvent() {
        if (this.configurationRef == null || this.configurationRef.get() == null) {
            return null;
        }
        MuleConfiguration muleConfiguration = ((EvaluatorExtensionConfiguration)this.configurationRef.get()).getMuleConfiguration();
        if (muleConfiguration == null) {
            return null;
        }
        MetadataEvent metadataEvent = null;
        IMessageFlowNode messageFlowNode = ((EvaluatorExtensionConfiguration)this.configurationRef.get()).getNode();
        if (messageFlowNode == null) {
            metadataEvent = ToolingPropagationInfo.PropagationInfoBuilder.DEFAULT.getExpectedInputMetadataType();
        } else {
            IMuleProject project = ((EvaluatorExtensionConfiguration)this.configurationRef.get()).getProject();
            MulePath mulePath = muleConfiguration.getPathFor((IMessageFlowEntity)messageFlowNode);
            DataSenseRequest request = new DataSenseRequest(project, EditingScope.getCurrent(), muleConfiguration, mulePath, DataSenseRequest.DataSenseRequestType.PROPAGATION);
            CompletionStage propagationProvider = ((IDataSenseResolver)MuleCorePlugin.getStudioContext().get(IDataSenseResolver.class)).resolveDataSense(request).thenApply(DataSenseResponse::getPropagationInfo);
            try {
                metadataEvent = ((PropagationInfo)((CompletableFuture)propagationProvider).get()).getExpectedInputMetadataType();
            }
            catch (InterruptedException | ExecutionException e) {
                MuleCorePlugin.logError((String)"Error resolving metadata event", (Throwable)e);
            }
        }
        return metadataEvent;
    }
}

