/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.IRegion;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.ClassInstanceFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ProposalFactory;
import org.mule.tooling.utils.ObjectHolder;

public class MetadataModelFieldResolver
implements FieldResolver {
    private MetadataType model;
    private IObjectRef<EvaluatorExtensionConfiguration> configurationRef;

    public MetadataModelFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef, MetadataType metadataType) {
        this.configurationRef = configurationRef;
        this.model = metadataType;
    }

    @Override
    public List<ComparableCompletionProposal> getFields(final IRegion replacementRange, final String lastWord) {
        final ArrayList<ComparableCompletionProposal> result = new ArrayList<ComparableCompletionProposal>();
        if (this.model != null) {
            this.model.accept(new MetadataTypeVisitor(){

                public void defaultVisit(MetadataType metadataType) {
                    this.solveSimpleType(metadataType);
                }

                public void visitObject(ObjectType objectType) {
                    if (objectType.isOpen()) {
                        if (objectType.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
                            this.solveSimpleType((MetadataType)BaseTypeBuilder.create((MetadataFormat)objectType.getMetadataFormat()).stringType().build());
                        }
                    } else {
                        this.solveDefinedFields(objectType.getFields());
                    }
                }

                public void visitArrayType(ArrayType arrayType) {
                    String implementationClass = MetadataUtils.getImplementationClass((MetadataType)arrayType);
                    result.addAll(new ClassInstanceFieldResolver(MetadataModelFieldResolver.this.configurationRef, implementationClass).getFields(replacementRange, lastWord));
                }

                private void solveSimpleType(MetadataType metadataType) {
                    String defaultImplementationClass = MetadataUtils.getImplementationClass((MetadataType)metadataType);
                    if (StringUtils.isNotBlank((String)defaultImplementationClass) && !defaultImplementationClass.equals(Void.class.getName())) {
                        result.addAll(new ClassInstanceFieldResolver(MetadataModelFieldResolver.this.configurationRef, defaultImplementationClass).getFields(replacementRange, lastWord));
                    }
                }

                protected void solveDefinedFields(Collection<ObjectFieldType> fields) {
                    for (ObjectFieldType field : fields) {
                        String name = field.getKey().getName().toString();
                        String implementationClass = MetadataUtils.getImplementationClass((MetadataType)field.getValue());
                        String label = name + " : " + implementationClass;
                        if (!name.startsWith(lastWord)) continue;
                        result.add(ProposalFactory.createFieldProposal(name, label, label, replacementRange));
                    }
                }
            });
        }
        return result;
    }

    @Override
    public FieldResolver getFieldResolver(String fieldName) {
        ObjectHolder result = new ObjectHolder();
        if (this.model != null) {
            this.model.accept((MetadataTypeVisitor)new FieldResolverMetaDataModelVisitor(fieldName, (ObjectHolder<FieldResolver>)result));
        }
        return (FieldResolver)result.get();
    }

    @Override
    public List<ComparableCompletionProposal> getMethods(final IRegion replacementRange, final String lastWord) {
        final ArrayList<ComparableCompletionProposal> result = new ArrayList<ComparableCompletionProposal>();
        if (this.model != null && this.model.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            this.model.accept(new MetadataTypeVisitor(){

                public void defaultVisit(MetadataType metadataType) {
                    this.addMethodFromSimpleType(metadataType);
                }

                public void visitArrayType(ArrayType arrayType) {
                    String dataClassName = MetadataUtils.getImplementationClass((MetadataType)arrayType);
                    if (StringUtils.isNotBlank((String)dataClassName)) {
                        this.addMethodDefinitionFromClassName(dataClassName);
                    } else {
                        this.addMethodFromSimpleType((MetadataType)arrayType);
                    }
                }

                private void addMethodFromSimpleType(MetadataType metadataType) {
                    this.addMethodDefinitionFromClassName(MetadataUtils.getImplementationClass((MetadataType)metadataType));
                }

                private void addMethodDefinitionFromClassName(String defaultImplementationClass) {
                    if (StringUtils.isNotBlank((String)defaultImplementationClass)) {
                        result.addAll(new ClassInstanceFieldResolver(MetadataModelFieldResolver.this.configurationRef, defaultImplementationClass).getMethods(replacementRange, lastWord));
                    }
                }
            });
        }
        return result;
    }

    @Override
    public FieldResolver getMethodResolver(final String functionName, final MethodCallNode methodCall) {
        final ObjectHolder result = new ObjectHolder();
        if (this.model != null && this.model.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            this.model.accept(new MetadataTypeVisitor(){

                public void defaultVisit(MetadataType metadataType) {
                    this.resolveMethodResolverFromSimpleType(metadataType);
                }

                public void visitArrayType(ArrayType arrayType) {
                    if (!StringUtils.isEmpty((String)functionName)) {
                        if (functionName.equals("get")) {
                            result.set((Object)new MetadataModelFieldResolver(MetadataModelFieldResolver.this.configurationRef, arrayType.getType()));
                        } else {
                            this.resolveMethodResolverFromSimpleType(MetadataModelFieldResolver.this.model);
                        }
                    }
                }

                private void resolveMethodResolverFromSimpleType(MetadataType metadataType) {
                    this.resolveMethodResolverFromClassName(MetadataUtils.getImplementationClass((MetadataType)metadataType));
                }

                private void resolveMethodResolverFromClassName(String defaultImplementationClass) {
                    if (StringUtils.isNotBlank((String)defaultImplementationClass)) {
                        result.set((Object)new ClassInstanceFieldResolver(MetadataModelFieldResolver.this.configurationRef, defaultImplementationClass).getMethodResolver(functionName, methodCall));
                    }
                }
            });
        }
        return (FieldResolver)result.get();
    }

    private final class FieldResolverMetaDataModelVisitor
    extends MetadataTypeVisitor {
        private final String fieldName;
        private final ObjectHolder<FieldResolver> result;

        private FieldResolverMetaDataModelVisitor(String fieldName, ObjectHolder<FieldResolver> result) {
            this.fieldName = fieldName;
            this.result = result;
        }

        public void defaultVisit(MetadataType metadataType) {
            this.resolveFieldResolver(MetadataUtils.getImplementationClass((MetadataType)metadataType), this.fieldName);
        }

        public void visitObject(ObjectType objectType) {
            if (objectType.isOpen()) {
                if (objectType.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
                    this.resolveFieldResolver(MetadataUtils.getImplementationClass((MetadataType)BaseTypeBuilder.create((MetadataFormat)objectType.getMetadataFormat()).stringType().build()), this.fieldName);
                }
            } else {
                Optional field = objectType.getFieldByName(this.fieldName);
                if (field.isPresent()) {
                    this.result.set((Object)new MetadataModelFieldResolver(MetadataModelFieldResolver.this.configurationRef, ((ObjectFieldType)field.get()).getValue()));
                }
            }
        }

        public void visitArrayType(ArrayType arrayType) {
            if (StringUtils.isNotBlank((String)this.fieldName) && StringUtils.isNumeric((String)this.fieldName)) {
                this.result.set((Object)new MetadataModelFieldResolver(MetadataModelFieldResolver.this.configurationRef, arrayType.getType()));
            } else {
                this.resolveFieldResolver(MetadataUtils.getImplementationClass((MetadataType)MetadataModelFieldResolver.this.model), this.fieldName);
            }
        }

        private void resolveFieldResolver(String implementationClass, String fieldName) {
            this.result.set((Object)new ClassInstanceFieldResolver(MetadataModelFieldResolver.this.configurationRef, implementationClass).getFieldResolver(fieldName));
        }
    }
}

