/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.mel.partitioner.EvaluatorDamagerRepairer;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionManager;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.AnnotationHover;
import org.mule.tooling.ui.modules.core.autocomplete.mel.DefaultCompletionProcessor;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.DefaultScanner;

public class MELViewerConfiguration
extends SourceViewerConfiguration {
    private IAnnotationModel annotationModel;
    private IObjectRef<EvaluatorExtensionConfiguration> configurationRef;
    private CustomContentAssistant customContentAssistant;

    public MELViewerConfiguration(IAnnotationModel annotationModel, IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        this.annotationModel = annotationModel;
        this.configurationRef = configurationRef;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer melContentRepairer = EvaluatorExtensionManager.getInstance().getDefaultExpressionLanguageEvaluator().getDamagerRepairer();
        presentationReconciler.setRepairer((IPresentationRepairer)melContentRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.MEL_CONTENT_TYPE");
        presentationReconciler.setRepairer((IPresentationRepairer)melContentRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE");
        presentationReconciler.setDamager((IPresentationDamager)melContentRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.MEL_CONTENT_TYPE");
        presentationReconciler.setDamager((IPresentationDamager)melContentRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE");
        EvaluatorDamagerRepairer evaluatorRepairer = EvaluatorExtensionManager.getInstance().getDamagerRepairer();
        presentationReconciler.setRepairer((IPresentationRepairer)evaluatorRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_CONTENT_TYPE");
        presentationReconciler.setDamager((IPresentationDamager)evaluatorRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_CONTENT_TYPE");
        RuleBasedScanner evaluatorScanner = new RuleBasedScanner();
        Color evaluatorDeclarationColor = Display.getCurrent().getSystemColor(14);
        evaluatorScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(evaluatorDeclarationColor, null, 1)));
        DefaultDamagerRepairer evaluatorDeclarationRepairer = new DefaultDamagerRepairer((ITokenScanner)evaluatorScanner);
        presentationReconciler.setRepairer((IPresentationRepairer)evaluatorDeclarationRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_DECLARATION_CONTENT_TYPE");
        presentationReconciler.setRepairer((IPresentationRepairer)evaluatorDeclarationRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_COLON_CONTENT_TYPE");
        presentationReconciler.setDamager((IPresentationDamager)evaluatorDeclarationRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_DECLARATION_CONTENT_TYPE");
        presentationReconciler.setDamager((IPresentationDamager)evaluatorDeclarationRepairer, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_COLON_CONTENT_TYPE");
        DefaultDamagerRepairer defaultRepairer = new DefaultDamagerRepairer((ITokenScanner)new DefaultScanner());
        presentationReconciler.setRepairer((IPresentationRepairer)defaultRepairer, "__dftl_partition_content_type");
        presentationReconciler.setDamager((IPresentationDamager)defaultRepairer, "__dftl_partition_content_type");
        return presentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        CustomContentAssistant contentAssistant = new CustomContentAssistant();
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setAutoActivationDelay(1);
        contentAssistant.enablePrefixCompletion(true);
        contentAssistant.setProposalPopupOrientation(10);
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setShowEmptyList(false);
        IContentAssistProcessor completionProcessor = EvaluatorExtensionManager.getInstance().getCompletionProcessor(this.configurationRef);
        contentAssistant.setContentAssistProcessor(completionProcessor, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_COLON_CONTENT_TYPE");
        contentAssistant.setContentAssistProcessor(completionProcessor, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_CONTENT_TYPE");
        IContentAssistProcessor defaultExpressionLanguageContentAssistProcessor = EvaluatorExtensionManager.getInstance().getDefaultExpressionLanguageEvaluator().getContentAssistProcessor(this.configurationRef);
        contentAssistant.setContentAssistProcessor(defaultExpressionLanguageContentAssistProcessor, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE");
        contentAssistant.setContentAssistProcessor(defaultExpressionLanguageContentAssistProcessor, "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.MEL_CONTENT_TYPE");
        contentAssistant.setContentAssistProcessor(new DefaultCompletionProcessor(), "__dftl_partition_content_type");
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        });
        this.customContentAssistant = contentAssistant;
        return contentAssistant;
    }

    public boolean isActivePopup() {
        return this.customContentAssistant.isActivePopup();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        EvaluatorExtension manager = EvaluatorExtensionManager.getInstance().getDefaultExpressionLanguageEvaluator();
        return manager.createTextHover(this.configurationRef);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return super.getHyperlinkDetectors(sourceViewer);
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return new TextViewerUndoManager(100);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover(this.annotationModel);
    }

    public static class CustomContentAssistant
    extends ContentAssistant {
        protected ContentAssistant.AutoAssistListener createAutoAssistListener() {
            ContentAssistant.AutoAssistListener listener = new ContentAssistant.AutoAssistListener(this){

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 4: 
                        case 9: 
                        case 13: 
                        case 0x1000001: 
                        case 0x1000002: {
                            this.setFocus(null);
                        }
                    }
                    super.keyPressed(e);
                }
            };
            return listener;
        }

        public boolean isActivePopup() {
            return this.isProposalPopupActive();
        }
    }
}

