/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.DefaultEvaluatorConfiguration;
import org.mule.tooling.core.utils.ValidationUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;

public class MELValidator {
    public static final String ID = "org.mule.tooling.ui.modules.core.autocomplete.mel.MELValidator";
    private final IMuleProject muleProject;

    public MELValidator(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public void validateAsync(final IDocument document, final MuleConfiguration muleConfiguration, final IMessageFlowNode messageFlowNode, final IStatusCallback callback) {
        if (messageFlowNode == null) {
            return;
        }
        Runnable validate = new Runnable(){

            @Override
            public void run() {
                MulePath mulePath = muleConfiguration.getPathFor((IMessageFlowEntity)messageFlowNode);
                if (mulePath != null) {
                    IStatus validateDocument = MELValidator.this.validateDocument(document, muleConfiguration, messageFlowNode);
                    callback.onResult(validateDocument);
                }
            }
        };
        new Thread(validate, "MELValidator").start();
    }

    public IStatus validateDocument(IDocument document, MuleConfiguration muleConfiguration, IMessageFlowNode messageFlowNode) {
        DefaultEvaluatorConfiguration configuration = new DefaultEvaluatorConfiguration(this.muleProject, messageFlowNode, muleConfiguration);
        return new ValidationUtils((EvaluatorExtensionConfiguration)configuration).validate(document.get(), messageFlowNode.getType());
    }

    public static interface IStatusCallback {
        public void onResult(IStatus var1);
    }
}

