/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.DotFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FunctionDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.mel.ExtendedMELCompletionManager;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MuleExpressionFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Keyword;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ProposalFactory;

public class MELRootFieldResolver
extends MuleExpressionFieldResolver {
    private static Map<String, FieldDefinition> fields = new HashMap<String, FieldDefinition>();
    private static Map<String, FunctionDefinition> methods = new HashMap<String, FunctionDefinition>();

    public MELRootFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        super(configurationRef);
    }

    @Override
    public FieldResolver getFieldResolver(String fieldName) {
        if (fieldName.equals(".")) {
            return new DotFieldResolver((IObjectRef<EvaluatorExtensionConfiguration>)this.configurationRef);
        }
        return new DotFieldResolver((IObjectRef<EvaluatorExtensionConfiguration>)this.configurationRef).getFieldResolver(fieldName);
    }

    @Override
    public List<ComparableCompletionProposal> getFields(IRegion replacementRange, String lastWord) {
        List<ComparableCompletionProposal> result = super.getFields(replacementRange, lastWord);
        this.addKeywordProposals(result, replacementRange, lastWord);
        return result;
    }

    private void addKeywordProposals(List<ComparableCompletionProposal> result, IRegion replacementRange, String lastWord) {
        if (!StringUtils.isEmpty((String)lastWord)) {
            Keyword[] keywordArray = Keyword.values();
            int n = keywordArray.length;
            int n2 = 0;
            while (n2 < n) {
                Keyword keyword = keywordArray[n2];
                if (keyword.toString().toLowerCase().startsWith(lastWord.toLowerCase())) {
                    result.add(ProposalFactory.createKeywordProposal(keyword.toString(), replacementRange));
                }
                ++n2;
            }
        }
    }

    @Override
    public List<ComparableCompletionProposal> getMethods(IRegion replacementRange, String lastWord) {
        List<ComparableCompletionProposal> result = super.getMethods(replacementRange, lastWord);
        this.addTemplateProposals(result, replacementRange, lastWord);
        return result;
    }

    @Override
    protected Map<String, FunctionDefinition> getMethodDefinitions() {
        HashMap<String, FunctionDefinition> methods = new HashMap<String, FunctionDefinition>();
        methods.putAll(MELRootFieldResolver.getRootMethodDefinitions());
        methods.putAll(this.getExtendedMethodDefinitions());
        return methods;
    }

    @Override
    protected Map<String, FieldDefinition> getFieldDefinitions() {
        HashMap<String, FieldDefinition> fields = new HashMap<String, FieldDefinition>();
        fields.putAll(MELRootFieldResolver.getRootFieldDefinitions());
        fields.putAll(this.getExtendedFieldDefinitions());
        return fields;
    }

    private Map<String, FunctionDefinition> getExtendedMethodDefinitions() {
        Map<String, FunctionDefinition> methodDefinitions = this.configurationRef != null && this.configurationRef.get() != null && ((EvaluatorExtensionConfiguration)this.configurationRef.get()).getNode() != null ? ExtendedMELCompletionManager.getMethodDefinitions(((EvaluatorExtensionConfiguration)this.configurationRef.get()).getNode()) : Collections.emptyMap();
        return methodDefinitions;
    }

    private Map<String, FieldDefinition> getExtendedFieldDefinitions() {
        Map<String, FieldDefinition> fieldDefinitions = this.configurationRef != null && this.configurationRef.get() != null && ((EvaluatorExtensionConfiguration)this.configurationRef.get()).getNode() != null ? ExtendedMELCompletionManager.getFieldDefinitions(((EvaluatorExtensionConfiguration)this.configurationRef.get()).getNode()) : Collections.emptyMap();
        return fieldDefinitions;
    }

    private void addTemplateProposals(List<ComparableCompletionProposal> proposals, IRegion replacementRange, String lastWord) {
        if (!StringUtils.isEmpty((String)lastWord)) {
            if ("if".startsWith(lastWord.toLowerCase())) {
                proposals.add(ProposalFactory.createTemplateProposal("if(condition){}else{}", "if", "if/else statement", Arrays.asList(new Region(3, 9)), replacementRange));
                proposals.add(ProposalFactory.createTemplateProposal("condition? trueValue : falseValue ;", "inline if", "inline if statement", Arrays.asList(new Region(0, 9), new Region(11, 9), new Region(23, 10)), replacementRange));
            }
            if ("foreach".startsWith(lastWord.toLowerCase())) {
                proposals.add(ProposalFactory.createTemplateProposal("foreach (item : iterable) {}", "foreach", "foreach statement", Arrays.asList(new Region(9, 4), new Region(16, 8)), replacementRange));
            }
            if ("do/while".startsWith(lastWord.toLowerCase()) || "while".startsWith(lastWord.toLowerCase())) {
                proposals.add(ProposalFactory.createTemplateProposal("do { } while (condition);", "do/while", "do/while statement", Arrays.asList(new Region(14, 9)), replacementRange));
            }
            if ("while".startsWith(lastWord.toLowerCase())) {
                proposals.add(ProposalFactory.createTemplateProposal("while (condition) {}", "while", "while statement", Arrays.asList(new Region(7, 9)), replacementRange));
            }
            if ("until".startsWith(lastWord.toLowerCase())) {
                proposals.add(ProposalFactory.createTemplateProposal("until (condition) {}", "until", "until statement", Arrays.asList(new Region(7, 9)), replacementRange));
            }
        }
    }

    public static Map<String, FunctionDefinition> getRootMethodDefinitions() {
        if (methods.isEmpty()) {
            methods.put("xpath", new FunctionDefinition("xpath", new String[]{"xPathExpression"}, "org.dom4j.Node", "allows to evaluate XPath expressions.\n xpath(xPathExpression):dom4j Node: applies the xPathExpression to message.payload and returns dom4j Node with the result"));
            methods.put("dw", new FunctionDefinition("dw", new String[]{"dataWeaveExpression"}, Object.class.getName(), "allows to evaluate weave expressions.\n weave(weaveExpression):Map  applies the weaveExpression to message and returns a Java object with the result"));
            methods.put("dw_2", new FunctionDefinition("dw", new String[]{"dataWeaveExpression", "mimeType"}, Object.class.getName(), "allows to evaluate weave expressions.\n weave(weaveExpression,mimeType):Object  applies the weaveExpression to message and returns the result with the given mime type."));
            methods.put("xpath_2", new FunctionDefinition("xpath", new String[]{"xPathExpression", "xmlElement"}, "org.dom4j.Node", "allows to evaluate XPath expressions.\n xpath(xPathExpression, xmlElement):dom4j Node: applies the xPathExpression to xmlElement and returns dom4j Node with the result"));
            methods.put("regex", new FunctionDefinition("regex", new String[]{"regularExpression"}, Object.class.getName(), "The regex function enables you to use regular expressions from within MEL\nregex(regularExpression)- applies the regular expression to the payload and retrieve a single value or an array of values, depending on matches."));
            methods.put("regex_2", new FunctionDefinition("regex", new String[]{"regularExpression", "melExpression"}, Object.class.getName(), "The regex function enables you to use regular expressions from within MEL\nregex(regularExpression, melExpression)- applies the regular expression to the melExpression result and retrieve null, a single value or an array of values, depending on matches."));
            methods.put("regex_3", new FunctionDefinition("regex", new String[]{"regularExpression", "melExpression", "matchFlags"}, Object.class.getName(), "The regex function enables you to use regular expressions from within MEL \nregex(regularExpression, melExpression, matchFlags )- applies the regular expression to the melExpression result applying the regex matchFlags and retrieve null, a single value or an array of values, depending on matches."));
        }
        return methods;
    }

    public static Map<String, FieldDefinition> getRootFieldDefinitions() {
        if (fields.isEmpty()) {
            fields.put("message", new FieldDefinition("message", "message", "Properties of the message that engine is processing.", null));
            fields.put("payload", new FieldDefinition("payload", "payload", "Mule message payload", null));
            fields.put("server", new FieldDefinition("server", "server", "Properties of the hardware, operating system, user, and network interface.", null));
            fields.put("mule", new FieldDefinition("mule", "mule", "Properties of the Mule instance on which the application is running.", null));
            fields.put("app", new FieldDefinition("app", "app", "Properties of the user application within which the current flow is deployed.", null));
            fields.put("vars", new FieldDefinition("vars", "vars", "Mule message variables", Map.class.getName()));
            fields.put("validator", new FieldDefinition("validator", "validator", "A class which allows executing instances of org.mule.extension.validation.internal.validator.AbstractValidator's from a MEL context.<br/>Unlike regular validations which throw an exception upon failure, the methods in this class will only return boolean values to indicate if the validation was successful or not. Also, no message is returned in either case.<br/>Since in this case we only care about the boolean result of the validation, all validations will be executed with the same ValidationContext.<br/>Validator instances are not reused. A new one is created each time.<br/><b>Since 3.7.0</b>", "org.mule.extension.validation.internal.el.ValidatorElContext"));
        }
        return fields;
    }
}

