/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FunctionDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELCompletionFilter;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELFieldProposal;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELMethodProposal;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;

@ExtensionPoint(extensionPointId="org.mule.tooling.ui.modules.core.melcompletionproposal")
public class MELCompletionProposal {
    @ExtensionAttribute
    private MELCompletionFilter filterClass;
    @ExtensionChildElement(childElementsName="methodProposal", elementType=MELMethodProposal.class)
    private Collection<MELMethodProposal> methodProposals;
    @ExtensionChildElement(childElementsName="fieldProposal", elementType=MELFieldProposal.class)
    private Collection<MELFieldProposal> fieldProposals;

    public boolean accepts(IMessageFlowNode node) {
        return this.filterClass.accept(node);
    }

    public Collection<MELMethodProposal> getMethodProposals() {
        return this.methodProposals;
    }

    public Collection<MELFieldProposal> getFieldProposals() {
        return this.fieldProposals;
    }

    public MELCompletionFilter getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(MELCompletionFilter filterClass) {
        this.filterClass = filterClass;
    }

    public void setMethodProposals(Collection<MELMethodProposal> methodProposals) {
        this.methodProposals = methodProposals;
    }

    public void setFieldProposals(Collection<MELFieldProposal> fieldProposals) {
        this.fieldProposals = fieldProposals;
    }

    public Map<String, FunctionDefinition> getMethodProposalsMap() {
        HashMap<String, FunctionDefinition> proposalsMap = new HashMap<String, FunctionDefinition>();
        for (MELMethodProposal methodProposal : this.methodProposals) {
            proposalsMap.put(methodProposal.getId(), methodProposal.getFunctionDefinition());
        }
        return proposalsMap;
    }

    public Map<String, FieldDefinition> getFieldProposalsMap() {
        HashMap<String, FieldDefinition> proposalsMap = new HashMap<String, FieldDefinition>();
        for (MELFieldProposal fieldProposal : this.fieldProposals) {
            proposalsMap.put(fieldProposal.getId(), fieldProposal.getFieldDefinition());
        }
        return proposalsMap;
    }
}

