/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELAnalyzer;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.AbstractCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.MethodCompletionProposal;

public class MELCompletionProcessor
implements IContentAssistProcessor,
IContentProposalProvider {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    public static final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'.', ','};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private IObjectRef<EvaluatorExtensionConfiguration> configurationRef;

    public MELCompletionProcessor(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        this.configurationRef = configurationRef;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        Document document = new Document(contents);
        ICompletionProposal[] completionProposals = this.doComputeCompletionProposals(position, (IDocument)document);
        String lastWord = this.lastWord((IDocument)document, position);
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        ICompletionProposal[] iCompletionProposalArray = completionProposals;
        int n = completionProposals.length;
        int n2 = 0;
        while (n2 < n) {
            String content;
            ICompletionProposal completion = iCompletionProposalArray[n2];
            if (completion instanceof AbstractCompletionProposal) {
                AbstractCompletionProposal abstractCompletionProposal = (AbstractCompletionProposal)completion;
                content = abstractCompletionProposal.getReplacementString();
            } else if (completion instanceof MethodCompletionProposal) {
                MethodCompletionProposal methodCompletionProposal = (MethodCompletionProposal)completion;
                content = methodCompletionProposal.getReplacementString();
            } else {
                content = completion.getDisplayString();
            }
            if (content.startsWith(lastWord)) {
                content = content.substring(lastWord.length());
            }
            proposals.add(new ContentProposal(content, completion.getDisplayString(), completion.getAdditionalProposalInfo()));
            ++n2;
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        return this.doComputeCompletionProposals(offset, document);
    }

    private ICompletionProposal[] doComputeCompletionProposals(int offset, IDocument document) {
        try {
            String lastWord = this.lastWord(document, offset);
            Region replacementRegion = new Region(offset - lastWord.length(), lastWord.length());
            MELAnalyzer scriptAnalyzer = new MELAnalyzer(this.configurationRef);
            Region parseRange = this.getParseRange(document, offset, lastWord);
            List<ICompletionProposal> analyzeResult = scriptAnalyzer.analyze(document, (IRegion)parseRange, (IRegion)replacementRegion, lastWord);
            return analyzeResult.toArray(new ICompletionProposal[analyzeResult.size()]);
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error While Building AutoComplete", (Throwable)e);
            return this.NO_COMPLETIONS;
        }
    }

    protected Region getParseRange(IDocument document, int offset, String lastWord) throws BadLocationException {
        ITypedRegion partition = document.getPartition(offset);
        int lengthToAnalyze = offset - lastWord.length() - partition.getOffset();
        Region parseRange = new Region(partition.getOffset(), lengthToAnalyze);
        return parseRange;
    }

    private String lastWord(IDocument doc, int offset) {
        StringBuilder result = new StringBuilder();
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (!Character.isJavaIdentifierPart(c)) {
                    return result.toString();
                }
                result.insert(0, c);
                --n;
            }
        }
        catch (BadLocationException e) {
            MuleCorePlugin.logWarning((String)"Autocompletion: Unable to get last word", (Throwable)e);
        }
        return result.toString();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "no autocomplete information";
    }
}

