/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.ClassInstanceFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.ScriptAnalyzer;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELRootFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MetadataModelFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MulePayloadFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.VariablesFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Operator;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ASTNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.parser.BinaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CollectionAccessNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CommentNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContainerAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.InlineCollectionNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.KeywordNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELParser;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MapEntryNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.NumberLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ScriptNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StatementNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StringLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.UnaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.VariableDeclarationNode;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;

public class MELAnalyzer
implements ScriptAnalyzer {
    private IObjectRef<EvaluatorExtensionConfiguration> configurationParams;

    public MELAnalyzer(IObjectRef<EvaluatorExtensionConfiguration> configurationParams) {
        this.configurationParams = configurationParams;
    }

    @Override
    public List<ICompletionProposal> analyze(IDocument document, IRegion parserRange, IRegion replacementRange, String lastWord) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        ScriptNode parseExpressions = new MELParser(document, parserRange).parse();
        MELNodeVisitor visitor = new MELNodeVisitor();
        parseExpressions.accept(visitor);
        FieldResolver fieldResolver = visitor.getFieldResolver();
        List<ComparableCompletionProposal> fields = fieldResolver.getFields(replacementRange, lastWord);
        Collections.sort(fields);
        result.addAll(fields);
        List<ComparableCompletionProposal> methods = fieldResolver.getMethods(replacementRange, lastWord);
        Collections.sort(methods);
        result.addAll(methods);
        return result;
    }

    private final class MELNodeVisitor
    implements ASTNodeVisitor {
        private FieldResolver fieldResolver;
        private MELRootFieldResolver defaultFieldResolver;

        public MELNodeVisitor() {
            this.defaultFieldResolver = new MELRootFieldResolver(MELAnalyzer.this.configurationParams);
            this.setFieldResolver(this.defaultFieldResolver);
        }

        @Override
        public void visitStringLiteral(StringLiteralNode expression) {
            if (this.getFieldResolver() instanceof VariablesFieldResolver || this.getFieldResolver() instanceof MulePayloadFieldResolver) {
                this.setFieldResolver(this.getFieldResolver().getFieldResolver(expression.getContent()));
            } else {
                this.setFieldResolver(new ClassInstanceFieldResolver(MELAnalyzer.this.configurationParams, String.class.getName()));
            }
        }

        @Override
        public void visitScriptExpression(ScriptNode expression) {
            this.visitChildren(expression);
        }

        @Override
        public void visitMapEntry(MapEntryNode mapEntryNode) {
            this.visitChildren(mapEntryNode);
        }

        @Override
        public void visitOperator(BinaryOperatorNode operatorNode) {
            Operator operator = operatorNode.getOperator();
            switch (operator) {
                case DOT: 
                case QUESTION_MARK_DOT: {
                    this.setFieldResolver(this.getFieldResolver().getFieldResolver("."));
                    this.visitChildren(operatorNode);
                    break;
                }
                case EXCLAMATION: 
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_EQUALS: 
                case GREAT_EQUALS: 
                case EQUAL_EQUAL: 
                case DIFFERENT: 
                case AND: 
                case OR: 
                case EQUAL: {
                    operatorNode.getLeft().accept(this);
                    this.setFieldResolver(this.defaultFieldResolver);
                    IASTNode right = operatorNode.getRight();
                    if (right == null) break;
                    right.accept(this);
                    break;
                }
                default: {
                    this.visitChildren(operatorNode);
                }
            }
        }

        @Override
        public void visitMethodCall(MethodCallNode methodCallNode) {
            if (!methodCallNode.isClosed()) {
                this.visitChildren(methodCallNode);
            } else {
                this.setFieldResolver(this.getFieldResolver().getMethodResolver(methodCallNode.getContent(), methodCallNode));
            }
        }

        @Override
        public void visitIdentifier(IdentifierNode expression) {
            String value = expression.getContent();
            this.setFieldResolver(this.getFieldResolver().getFieldResolver(value));
        }

        @Override
        public void visitKeyword(KeywordNode keywordExpression) {
        }

        @Override
        public void visitUnaryOperator(UnaryOperatorNode unaryOperatorNode) {
        }

        @Override
        public void visitComment(CommentNode commentExpression) {
        }

        @Override
        public void visitNumberLiteral(NumberLiteralNode numberLiteralExpression) {
            if (this.getFieldResolver() instanceof MetadataModelFieldResolver || this.getFieldResolver() instanceof MulePayloadFieldResolver) {
                this.setFieldResolver(this.getFieldResolver().getFieldResolver(numberLiteralExpression.getContent()));
            }
        }

        @Override
        public void visitStatement(StatementNode statementNode) {
            this.visitChildren(statementNode);
        }

        @Override
        public void visitVariableDeclaration(VariableDeclarationNode variableDeclaration) {
            this.visitChildren(variableDeclaration);
        }

        private void visitChildren(IContainerAwareNode node) {
            for (IASTNode child : node.getChildren()) {
                child.accept(this);
            }
        }

        public FieldResolver getFieldResolver() {
            return this.fieldResolver;
        }

        public void setFieldResolver(FieldResolver fieldResolver) {
            this.fieldResolver = fieldResolver == null ? this.defaultFieldResolver : fieldResolver;
        }

        @Override
        public void visitCollectionAccessNode(CollectionAccessNode collectionAccessNode) {
            collectionAccessNode.getLeft().accept(this);
            IASTNode right = collectionAccessNode.getRight();
            if (right != null) {
                right.accept(this);
            }
        }

        @Override
        public void visitInlineCollectionNode(InlineCollectionNode inlineCollectionNode) {
            this.visitChildren(inlineCollectionNode);
        }
    }
}

