/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.FieldCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ProposalFactory;

public class DefaultCompletionProcessor
implements IContentAssistProcessor {
    public static final String ATTRIBUTES = "#[attributes]";
    public static final String EMPTY = "#[]";
    public static final String MESSAGE = "#[message]";
    public static final String PAYLOAD = "#[payload]";
    public static final String VARS = "#[vars]";

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<FieldCompletionProposal> response = new ArrayList<FieldCompletionProposal>();
        String lastWord = this.lastWord(viewer.getDocument(), offset);
        Region replacementRegion = new Region(offset - lastWord.length(), lastWord.length());
        if (lastWord.isEmpty() || EMPTY.startsWith(lastWord)) {
            response.add(ProposalFactory.createFieldProposal(EMPTY, EMPTY, "script block", (IRegion)replacementRegion, EMPTY.length() - 1));
            response.add(ProposalFactory.createFieldProposal(ATTRIBUTES, ATTRIBUTES, "attributes script block", (IRegion)replacementRegion, ATTRIBUTES.length() - 1));
            response.add(ProposalFactory.createFieldProposal(MESSAGE, MESSAGE, "message script block", (IRegion)replacementRegion, MESSAGE.length() - 1));
            response.add(ProposalFactory.createFieldProposal(PAYLOAD, PAYLOAD, "payload script block", (IRegion)replacementRegion, PAYLOAD.length() - 1));
            response.add(ProposalFactory.createFieldProposal(VARS, VARS, "vars script block", (IRegion)replacementRegion, VARS.length() - 1));
        }
        if (!lastWord.isEmpty() && "payload".startsWith(lastWord)) {
            response.add(ProposalFactory.createFieldProposal(PAYLOAD, PAYLOAD, "payload script block", (IRegion)replacementRegion));
        }
        return response.toArray(new ICompletionProposal[response.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return "#".toCharArray();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return "no autocompletion information.";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private String lastWord(IDocument doc, int offset) {
        StringBuilder result = new StringBuilder();
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (!Character.isJavaIdentifierPart(c) && '#' != c) {
                    return result.toString();
                }
                result.insert(0, c);
                --n;
            }
        }
        catch (BadLocationException e) {
            MuleCorePlugin.logWarning((String)"Autocompletion: Unable to get last word", (Throwable)e);
        }
        return result.toString();
    }
}

