/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.eclipse.jface.text.IRegion;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.NullFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MetadataModelFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MetadataResolver;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ProposalFactory;

public class AttributesFieldResolver
implements FieldResolver {
    private ObjectType variables;
    private IObjectRef<EvaluatorExtensionConfiguration> configurationRef;

    public AttributesFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        this.configurationRef = configurationRef;
        this.variables = new MetadataResolver(configurationRef).resolveVariables();
    }

    @Override
    public FieldResolver getFieldResolver(String fieldName) {
        Optional maybeField = this.variables.getFieldByName(fieldName);
        if (maybeField.isPresent()) {
            MetadataType metaDataModel = ((ObjectFieldType)maybeField.get()).getValue();
            return new MetadataModelFieldResolver(this.configurationRef, metaDataModel);
        }
        return NullFieldResolver.INSTANCE;
    }

    @Override
    public List<ComparableCompletionProposal> getFields(IRegion replacementRange, String lastWord) {
        ArrayList<ComparableCompletionProposal> fields = new ArrayList<ComparableCompletionProposal>();
        for (ObjectFieldType variables : this.variables.getFields()) {
            QName variableName = variables.getKey().getName();
            if (!variableName.getLocalPart().startsWith(lastWord)) continue;
            fields.add(ProposalFactory.createMapKeyFieldProposal(variableName.toString(), variableName.toString(), variableName.toString(), replacementRange));
        }
        return fields;
    }

    @Override
    public List<ComparableCompletionProposal> getMethods(IRegion replacementRange, String lastWord) {
        return Collections.emptyList();
    }

    @Override
    public FieldResolver getMethodResolver(String name, MethodCallNode methodCall) {
        return NullFieldResolver.INSTANCE;
    }
}

