/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.extension;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolverFactory;

public class AutocompletionExtensionManager {
    private static AutocompletionExtensionManager INSTANCE;
    private List<FieldResolverFactory> fieldResolverFactories;

    public static AutocompletionExtensionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutocompletionExtensionManager();
        }
        return INSTANCE;
    }

    public FieldResolver findResolverFactoryFor(String fieldName, IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        FieldResolverFactory fieldResolverFactory = (FieldResolverFactory)Iterables.find(this.getFieldResolverFactories(), this.isFactoryForContext(fieldName, configurationRef), null);
        if (fieldResolverFactory == null) {
            return null;
        }
        return fieldResolverFactory.createResolverForString(fieldName, configurationRef);
    }

    private Predicate<? super FieldResolverFactory> isFactoryForContext(final String fieldName, final IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        return new Predicate<FieldResolverFactory>(){

            public boolean apply(FieldResolverFactory fieldResolverFactory) {
                return fieldResolverFactory.createResolverForString(fieldName, (IObjectRef<EvaluatorExtensionConfiguration>)configurationRef) != null;
            }
        };
    }

    private List<FieldResolverFactory> getFieldResolverFactories() {
        if (this.fieldResolverFactories == null) {
            this.fieldResolverFactories = CoreUtils.getExtensionPointObjects((String)"org.mule.tooling.ui.modules.core.autocompletion", FieldResolverFactory.class);
        }
        return this.fieldResolverFactories;
    }
}

