/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.evaluator;

import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.mule.tooling.core.mel.partitioner.DefaultEvaluatorResult;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.EvaluatorResult;
import org.mule.tooling.core.mel.partitioner.EvaluatorValidator;
import org.mule.tooling.core.utils.IObjectRef;

public class XpathEvaluatorExtension
implements EvaluatorExtension {
    public static final char EXPRESSION_TERMINATION_CHAR = ']';

    public String getName() {
        return "xpath";
    }

    public EvaluatorResult partition(String text) {
        char[] charArray = text.toCharArray();
        int length = charArray.length;
        int bracketLevel = 0;
        boolean insideString = false;
        StringBuilder expressionBuilder = new StringBuilder();
        int i = 0;
        while (i < length) {
            char character = charArray[i];
            if (character == ']' && bracketLevel == 0) break;
            expressionBuilder.append(character);
            if (character == '\'') {
                insideString = !insideString;
            } else if (!insideString) {
                if (character == '[') {
                    ++bracketLevel;
                } else if (character == ']' && bracketLevel > 0) {
                    --bracketLevel;
                }
            }
            ++i;
        }
        String expression = expressionBuilder.toString();
        return new DefaultEvaluatorResult(expression);
    }

    public IContentAssistProcessor getContentAssistProcessor(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        return null;
    }

    public EvaluatorValidator getValidator(EvaluatorExtensionConfiguration configuration) {
        return null;
    }

    public DefaultDamagerRepairer getDamagerRepairer() {
        return null;
    }

    public boolean isDefaultExpressionLanguage() {
        return false;
    }
}

