/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.evaluator;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.MuleClassLoader;
import org.mule.tooling.core.classloader.MuleClassLoaderUtils;
import org.mule.tooling.core.mel.partitioner.DefaultEvaluatorResult;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.EvaluatorResult;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELCompletionProcessor;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.expressions.IExpressionLanguage;
import org.mule.tooling.ui.modules.core.widgets.expressions.ISyntaxColorer;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class MvelExpressionLanguage
implements IExpressionLanguage {
    public static final char EXPRESSION_TERMINATION_CHAR = ']';

    public EvaluatorResult partition(String text) {
        char[] charArray = text.toCharArray();
        int length = charArray.length;
        int bracketLevel = 0;
        boolean insideString = false;
        StringBuilder expressionBuilder = new StringBuilder();
        int i = 0;
        while (i < length) {
            char character = charArray[i];
            if (character == ']' && bracketLevel == 0) break;
            expressionBuilder.append(character);
            if (character == '\'') {
                insideString = !insideString;
            } else if (!insideString) {
                if (character == '[') {
                    ++bracketLevel;
                } else if (character == ']' && bracketLevel > 0) {
                    --bracketLevel;
                }
            }
            ++i;
        }
        String expression = expressionBuilder.toString();
        return new DefaultEvaluatorResult(expression);
    }

    public IContentAssistProcessor getContentAssistProcessor(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        return new MELCompletionProcessor(configurationRef);
    }

    @Override
    public boolean computeCompletionProposals(ArrayList<ICompletionProposal> result, int offset, String fullString, String startString, String expression, int startPosition, int endPosition, boolean closed, int indexOf, AttributeContext ctx, ITextViewer viewer) {
        return false;
    }

    @Override
    public IValidator getExpressionValidator() {
        return new IValidator(){

            /*
             * Loose catch block
             */
            @Override
            public String validate(Object value, AttributeContext context, AttributeHelper helper) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                MuleClassLoader cl = null;
                try {
                    IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
                    String script = (String)value;
                    cl = MetadataUtils.createMuleClassLoader((IMuleProject)muleProject);
                    Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                    ExpressionCompiler compiler = new ExpressionCompiler(script);
                    compiler.compile();
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
                catch (CompileException compileError) {
                    String string = StringUtils.capitalize((String)compileError.getMessage());
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                    MuleClassLoaderUtils.dispose((ClassLoader)cl);
                    return string;
                }
                catch (Exception exception) {
                    return "Unexpected Error";
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                    MuleClassLoaderUtils.dispose(cl);
                }
                MuleClassLoaderUtils.dispose((ClassLoader)cl);
                return null;
            }
        };
    }

    @Override
    public IHyperlinkDetector getHyperlinkDetector() {
        return null;
    }

    @Override
    public ISyntaxColorer getSyntaxHighlighter() {
        return null;
    }
}

