/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.evaluator;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.tooling.core.classloader.MuleClassLoader;
import org.mule.tooling.core.classloader.MuleClassLoaderUtils;
import org.mule.tooling.core.mel.partitioner.DefaultEvaluatorResult;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.EvaluatorResult;
import org.mule.tooling.core.mel.partitioner.EvaluatorValidator;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELCompletionProcessor;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.MELScanner;

public class MvelEvaluatorExtension
implements EvaluatorExtension {
    public static final char EXPRESSION_TERMINATION_CHAR = ']';

    public String getName() {
        return "mel";
    }

    public EvaluatorResult partition(String text) {
        char[] charArray = text.toCharArray();
        int length = charArray.length;
        int bracketLevel = 0;
        boolean insideString = false;
        StringBuilder expressionBuilder = new StringBuilder();
        int i = 0;
        while (i < length) {
            char character = charArray[i];
            if (character == ']' && bracketLevel == 0) break;
            expressionBuilder.append(character);
            if (character == '\'') {
                insideString = !insideString;
            } else if (!insideString) {
                if (character == '[') {
                    ++bracketLevel;
                } else if (character == ']' && bracketLevel > 0) {
                    --bracketLevel;
                }
            }
            ++i;
        }
        String expression = expressionBuilder.toString();
        return new DefaultEvaluatorResult(expression);
    }

    public IContentAssistProcessor getContentAssistProcessor(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        return new MELCompletionProcessor(configurationRef);
    }

    public EvaluatorValidator getValidator(final EvaluatorExtensionConfiguration configuration) {
        return new EvaluatorValidator(){

            public IStatus validate(String script) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                MuleClassLoader cl = null;
                try {
                    cl = MetadataUtils.createMuleClassLoader((IMuleProject)configuration.getProject());
                    Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                    ExpressionCompiler compiler = new ExpressionCompiler(script);
                    compiler.compile();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (CompileException compileError) {
                    Status status = new Status(4, "org.mule.tooling.ui.modules.core.autocomplete.mel.MELValidator", StringUtils.capitalize((String)compileError.getMessage()), (Throwable)compileError);
                    return status;
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.mule.tooling.ui.modules.core.autocomplete.mel.MELValidator", "Unexpected Error", (Throwable)e);
                    return status;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                    MuleClassLoaderUtils.dispose((ClassLoader)cl);
                }
            }
        };
    }

    public DefaultDamagerRepairer getDamagerRepairer() {
        return new DefaultDamagerRepairer((ITokenScanner)new MELScanner());
    }

    public boolean isDefaultExpressionLanguage() {
        return false;
    }
}

