/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.analyzer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.IRegion;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.AbstractCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ProposalFactory;

public class PackageFieldResolver
implements FieldResolver {
    private IObjectRef<EvaluatorExtensionConfiguration> configurationRef;
    private List<IPackageFragment> packageFragments;

    public PackageFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef, String packageName) {
        this.configurationRef = configurationRef;
        this.packageFragments = this.getPackageFragment(packageName);
    }

    @Override
    public FieldResolver getFieldResolver(String fieldName) {
        return null;
    }

    @Override
    public List<ComparableCompletionProposal> getFields(IRegion replacementRange, String lastWord) {
        HashSet<AbstractCompletionProposal> result = new HashSet<AbstractCompletionProposal>();
        for (IPackageFragment packageFragment : this.packageFragments) {
            if (packageFragment == null) continue;
            try {
                Object elementName;
                ICompilationUnit[] cus = packageFragment.getCompilationUnits();
                ICompilationUnit[] iCompilationUnitArray = cus;
                int n = cus.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit cu = iCompilationUnitArray[n2];
                    elementName = cu.getElementName();
                    String cuName = ((String)elementName).substring(0, ((String)elementName).length() - ".java".length());
                    if (cuName.startsWith(lastWord)) {
                        result.add(ProposalFactory.createJavaClassProposal(cuName, cuName, null, replacementRange));
                    }
                    ++n2;
                }
                IClassFile[] classFiles = packageFragment.getClassFiles();
                elementName = classFiles;
                int n3 = classFiles.length;
                n = 0;
                while (n < n3) {
                    Object cf = elementName[n];
                    String elementName2 = cf.getElementName();
                    String cuName = elementName2.substring(0, elementName2.length() - ".class".length());
                    if (cuName.startsWith(lastWord) && !cuName.contains("$")) {
                        result.add(ProposalFactory.createJavaClassProposal(cuName, cuName, null, replacementRange));
                    }
                    ++n;
                }
                List<IPackageFragment> subPackages = PackageFieldResolver.getSubPackages(packageFragment);
                for (IPackageFragment pf : subPackages) {
                    elementName = pf.getElementName();
                    String subPackageName = ((String)elementName).substring(packageFragment.getElementName().length() + 1);
                    if (StringUtils.isBlank((String)subPackageName) || !subPackageName.startsWith(lastWord)) continue;
                    result.add(ProposalFactory.createPackageProposal(subPackageName, replacementRange));
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return new ArrayList<ComparableCompletionProposal>(result);
    }

    private static List<IPackageFragment> getSubPackages(IPackageFragment p) throws JavaModelException {
        IJavaElement[] packages;
        ArrayList<IPackageFragment> result = new ArrayList<IPackageFragment>();
        IJavaElement[] iJavaElementArray = packages = ((IPackageFragmentRoot)p.getParent()).getChildren();
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            IPackageFragment pf = (IPackageFragment)iJavaElement;
            String name = p.getElementName();
            String otherName = pf.getElementName();
            if (otherName.startsWith(name) && !otherName.equals(name)) {
                result.add(pf);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<ComparableCompletionProposal> getMethods(IRegion replacementRange, String lastWord) {
        return null;
    }

    @Override
    public FieldResolver getMethodResolver(String name, MethodCallNode methodCall) {
        return null;
    }

    protected List<IPackageFragment> getPackageFragment(String packageName) {
        final ArrayList<IPackageFragment> response = new ArrayList<IPackageFragment>();
        SearchPattern pattern = SearchPattern.createPattern((String)packageName, (int)2, (int)0, (int)0);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{((EvaluatorExtensionConfiguration)this.configurationRef.get()).getProject().getJavaProject()});
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getElement() instanceof IPackageFragment) {
                    response.add((IPackageFragment)match.getElement());
                }
            }
        };
        try {
            new SearchEngine().search(pattern, participants, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MuleCorePlugin.logWarning((String)"Classpath is incorrect", (Throwable)e);
        }
        return response;
    }
}

