/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.analyzer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IRegion;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.ClassInstanceFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.ClassStaticFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.DefaultFieldResolverFactory;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FunctionDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.NullFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.PackageFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.extension.AutocompletionExtensionManager;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELRootFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;

public class DotFieldResolver
implements FieldResolver {
    private IObjectRef<EvaluatorExtensionConfiguration> configurationRef;
    private LinkedList<String> members = new LinkedList();

    public DotFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        this.configurationRef = configurationRef;
    }

    @Override
    public FieldResolver getFieldResolver(String fieldName) {
        FieldResolver resolver = this.createResolverForString(fieldName, this.configurationRef);
        if (this.members.isEmpty() && resolver != null) {
            return resolver;
        }
        if (!fieldName.equals(".")) {
            this.members.add(fieldName);
        }
        return this;
    }

    @Override
    public List<ComparableCompletionProposal> getFields(IRegion replacementRange, String lastWord) {
        ArrayList<ComparableCompletionProposal> fields = new ArrayList<ComparableCompletionProposal>();
        PackageFieldResolver packageResolver = new PackageFieldResolver(this.configurationRef, this.getConcatenatedMembers());
        fields.addAll(packageResolver.getFields(replacementRange, lastWord));
        ClassStaticFieldResolver classStaticResolver = new ClassStaticFieldResolver(this.configurationRef, this.getConcatenatedMembers());
        fields.addAll(classStaticResolver.getFields(replacementRange, lastWord));
        return fields;
    }

    @Override
    public List<ComparableCompletionProposal> getMethods(IRegion replacementRange, String lastWord) {
        ClassStaticFieldResolver classStaticResolver = new ClassStaticFieldResolver(this.configurationRef, this.getConcatenatedMembers());
        return classStaticResolver.getMethods(replacementRange, lastWord);
    }

    @Override
    public FieldResolver getMethodResolver(String name, MethodCallNode methodCall) {
        if (this.members.isEmpty()) {
            Map<String, FunctionDefinition> rootMethodDefinitions = MELRootFieldResolver.getRootMethodDefinitions();
            if (rootMethodDefinitions.containsKey(name)) {
                return new ClassInstanceFieldResolver(this.configurationRef, rootMethodDefinitions.get(name).getReturnType());
            }
            return NullFieldResolver.INSTANCE;
        }
        return new ClassStaticFieldResolver(this.configurationRef, this.getConcatenatedMembers());
    }

    private String getConcatenatedMembers() {
        StringBuffer buffer = new StringBuffer();
        String delim = "";
        for (String member : this.members) {
            buffer.append(delim).append(member);
            delim = ".";
        }
        return buffer.toString();
    }

    private FieldResolver createResolverForString(String fieldName, IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        FieldResolver fieldResolver = AutocompletionExtensionManager.getInstance().findResolverFactoryFor(fieldName, configurationRef);
        if (fieldResolver != null) {
            return fieldResolver;
        }
        return DefaultFieldResolverFactory.getInstance().createResolverForString(fieldName, configurationRef);
    }
}

