/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.analyzer;

import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.ClassInstanceFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolverFactory;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MuleAppFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MuleFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MuleMessageFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MulePayloadFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MuleServerFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.mel.VariablesFieldResolver;

final class DefaultFieldResolverFactory
implements FieldResolverFactory {
    private static final DefaultFieldResolverFactory INSTANCE = new DefaultFieldResolverFactory();

    protected DefaultFieldResolverFactory() {
    }

    public static DefaultFieldResolverFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public FieldResolver createResolverForString(String fieldName, IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        if (fieldName.endsWith("payload")) {
            return new MulePayloadFieldResolver(configurationRef);
        }
        if (fieldName.endsWith("message")) {
            return new MuleMessageFieldResolver(configurationRef);
        }
        if ("vars".equals(fieldName)) {
            return new VariablesFieldResolver(configurationRef);
        }
        if (fieldName.endsWith("server")) {
            return new MuleServerFieldResolver(configurationRef);
        }
        if (fieldName.endsWith("app")) {
            return new MuleAppFieldResolver(configurationRef);
        }
        if (fieldName.endsWith("mule")) {
            return new MuleFieldResolver(configurationRef);
        }
        if (fieldName.endsWith("validator")) {
            return new ClassInstanceFieldResolver(configurationRef, "org.mule.extension.validation.internal.el.ValidatorElContext");
        }
        return null;
    }
}

