/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.IRegion;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.AbstractClassFieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ProposalFactory;
import org.mule.tooling.ui.modules.core.autocomplete.utils.JavaModelUtils;

public class ClassInstanceFieldResolver
extends AbstractClassFieldResolver {
    public ClassInstanceFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef, String fullyQualifiedClassName) {
        super(configurationRef, fullyQualifiedClassName);
    }

    @Override
    public FieldResolver getFieldResolver(String fieldName) {
        if (this.getType() != null) {
            try {
                IField field = this.getType().getField(fieldName);
                if (field != null) {
                    return new ClassInstanceFieldResolver(this.getConfigurationRef(), Signature.toString((String)field.getTypeSignature()));
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    @Override
    public List<ComparableCompletionProposal> getFields(IRegion replacementRange, String lastWord) {
        ArrayList<ComparableCompletionProposal> result = new ArrayList<ComparableCompletionProposal>();
        if (this.getType() != null) {
            try {
                IField[] iFieldArray = this.getType().getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (Flags.isPublic((int)field.getFlags()) && !Flags.isStatic((int)field.getFlags()) && field.getElementName().startsWith(lastWord)) {
                        String label = field.getElementName() + " : " + field.getTypeSignature();
                        result.add(ProposalFactory.createFieldProposal(field, label, replacementRange));
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)"Error getting fields", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public List<ComparableCompletionProposal> getMethods(IRegion replacementRange, String lastWord) {
        ArrayList<ComparableCompletionProposal> result = new ArrayList<ComparableCompletionProposal>();
        if (this.getType() != null) {
            try {
                Collection<IMethod> declaredMethods = this.getMethods();
                for (IMethod method : declaredMethods) {
                    if (!Flags.isPublic((int)method.getFlags()) || method.isConstructor() || !method.getElementName().startsWith(lastWord)) continue;
                    result.add(ProposalFactory.createMethodProposal(method, replacementRange));
                }
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    @Override
    public FieldResolver getMethodResolver(String name, MethodCallNode methodCall) {
        if (this.getType() != null) {
            try {
                Collection<IMethod> declaredMethods = this.getMethods();
                for (IMethod method : declaredMethods) {
                    if (!method.getElementName().equals(name) || method.getParameters().length != methodCall.getChildren().size()) continue;
                    return new ClassInstanceFieldResolver(this.getConfigurationRef(), JavaModelUtils.getResolvedTypeName(method.getReturnType(), method.getDeclaringType()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

