/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.analyzer;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldResolver;
import org.mule.tooling.ui.modules.core.utils.JDTUtils;

public abstract class AbstractClassFieldResolver
implements FieldResolver {
    private IType type;
    private IObjectRef<EvaluatorExtensionConfiguration> configurationRef;
    private String fullQualifiedClassName;

    public AbstractClassFieldResolver(IObjectRef<EvaluatorExtensionConfiguration> configurationRef, String fullQualifiedClassName) {
        this.setConfigurationRef(configurationRef);
        this.fullQualifiedClassName = fullQualifiedClassName;
    }

    protected IType getClassType(String className) {
        IJavaProject javaProject = ((EvaluatorExtensionConfiguration)this.getConfigurationRef().get()).getProject().getJavaProject();
        return JDTUtils.searchType(javaProject, className);
    }

    protected String getJavadoc(IMember member) throws JavaModelException {
        Reader htmlContentReader = JavadocContentAccess.getHTMLContentReader((IMember)member, (boolean)true, (boolean)true);
        return htmlContentReader != null ? AbstractClassFieldResolver.getString(htmlContentReader) : null;
    }

    private static String getString(Reader reader) {
        try {
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public IType getType() {
        if (this.type == null) {
            this.type = this.getClassType(this.fullQualifiedClassName);
        }
        return this.type;
    }

    private Collection<MethodWrapper> wrap(IMethod[] methods) {
        ArrayList<MethodWrapper> wrapped = new ArrayList<MethodWrapper>();
        if (methods != null) {
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                wrapped.add(new MethodWrapper(method));
                ++n2;
            }
        }
        return wrapped;
    }

    private Collection<IMethod> unwrap(Collection<MethodWrapper> wrappedMethods) {
        ArrayList<IMethod> unwrapped = new ArrayList<IMethod>();
        for (MethodWrapper wrapper : wrappedMethods) {
            unwrapped.add(wrapper.getMethod());
        }
        return unwrapped;
    }

    protected Collection<IMethod> getMethods() throws JavaModelException {
        HashSet<MethodWrapper> wrappedMethods = new HashSet<MethodWrapper>();
        IType methodContainer = this.getType();
        while (methodContainer != null) {
            wrappedMethods.addAll(this.wrap(methodContainer.getMethods()));
            methodContainer = this.getClassType(methodContainer.getSuperclassName());
        }
        Collection<IMethod> unwrapped = this.unwrap(wrappedMethods);
        return unwrapped;
    }

    public IObjectRef<EvaluatorExtensionConfiguration> getConfigurationRef() {
        return this.configurationRef;
    }

    public void setConfigurationRef(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        this.configurationRef = configurationRef;
    }

    private final class MethodWrapper {
        private final IMethod method;

        public MethodWrapper(IMethod method) {
            this.method = method;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.method.getElementName() == null ? 0 : this.method.getElementName().hashCode());
            result = 31 * result + this.method.getNumberOfParameters();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodWrapper other = (MethodWrapper)obj;
            if (this.method == null) {
                return other.method == null;
            }
            if (other.method == null) {
                return this.method == null;
            }
            return this.method.isSimilar(other.method);
        }

        public IMethod getMethod() {
            return this.method;
        }

        private AbstractClassFieldResolver getOuterType() {
            return AbstractClassFieldResolver.this;
        }
    }
}

