/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.client.metadata.IMetadataPropagationCache;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.platform.debug.DebugTraceProvider;
import org.mule.tooling.ui.modules.core.api.metadata.IDataSenseResolver;
import org.mule.tooling.ui.modules.core.metadata.DataSenseResolver;
import org.mule.tooling.ui.modules.core.metadata.propagation.MetadataPropagationCache;
import org.osgi.framework.BundleContext;

public class ModulesActivator
extends AbstractUIPlugin {
    public static final String EXTENSION_ID_AUTOCOMPLETION = "org.mule.tooling.ui.modules.core.autocompletion";
    public static final String PLUGIN_ID = "org.mule.tooling.ui.modules.core";
    private static ModulesActivator plugin;
    public static final String DISPATCH_METADATA_JOBS_ID;
    public static final String DISPATCH_METADATA_JOBS_TRACE_ID;
    public static final String ATTRIBUTE_CREATOR_ID;
    public static final String CREATE_UI_PERFORMANCE_ID;
    public static final String CREATE_UI_EDITOR_PERFORMANCE_ID;
    private DebugTraceProvider debugTraceProvider;

    static {
        DISPATCH_METADATA_JOBS_ID = DebugTraceProvider.createDebugOptions((String)"/dispatch-metadata-jobs");
        DISPATCH_METADATA_JOBS_TRACE_ID = DebugTraceProvider.createDebugOptions((String)"/dispatch-metadata-jobs-trace");
        ATTRIBUTE_CREATOR_ID = DebugTraceProvider.createDebugOptions((String)"/attribute-creator");
        CREATE_UI_PERFORMANCE_ID = DebugTraceProvider.createDebugOptions((String)"/create-ui-perf");
        CREATE_UI_EDITOR_PERFORMANCE_ID = DebugTraceProvider.createDebugOptions((String)"/create-ui-editor-perf");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.debugTraceProvider = DebugTraceProvider.newRegisterdInstance((BundleContext)context, (String)PLUGIN_ID);
        EclipseContextHelper helper = EclipseContextHelper.createHelper((IEclipseContext)MuleCorePlugin.getStudioContext());
        helper.configureInstance(IMetadataPropagationCache.class, (Object)MetadataPropagationCache.getInstance());
        helper.configureInstance(IDataSenseResolver.class, (Object)DataSenseResolver.getInstance());
    }

    public void stop(BundleContext context) throws Exception {
        this.stopAnyPendingJob();
        plugin = null;
        this.debugTraceProvider.unregister();
        super.stop(context);
    }

    private void stopAnyPendingJob() throws InterruptedException {
        IJobManager jobMan = Job.getJobManager();
        jobMan.cancel((Object)"DataSenseProcessor");
        jobMan.join((Object)"DataSenseProcessor", (IProgressMonitor)new NullProgressMonitor());
    }

    public static ModulesActivator getDefault() {
        return plugin;
    }

    public static void logError(String message, Throwable t) {
        ModulesActivator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message, t));
    }

    public static void logWarning(String message, Throwable t) {
        ModulesActivator.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, message, t));
    }

    public static DebugTrace debugTracer() {
        return ModulesActivator.getDefault().debugTraceProvider.debugTrace();
    }
}

