/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.eventtracking.http;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferType;
import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.common.internalhandler.serializer.mixin.AgentTrackingNotificationMixin;
import com.mulesoft.agent.common.internalhandler.splunk.transport.Transport;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.handlers.exception.InitializationException;
import com.mulesoft.agent.handlers.internal.buffer.DiscardingMessageBufferConfigurationFactory;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Response;

@Singleton
@Named(value="mule.agent.tracking.handler.http")
public class EventTrackingHttpInternalHandler
extends BufferedHandler<AgentTrackingNotification> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long FLUSH_FREQUENCY = 60000L;
    private static final int MAXIMUM_CAPACITY = 1000;
    private ObjectMapper objectMapper;
    private Transport<AgentTrackingNotification> transport;
    @Configurable(type=Type.DYNAMIC)
    String host;
    @Configurable(value="8080", type=Type.DYNAMIC)
    int port;
    @Configurable(type=Type.DYNAMIC)
    String path;
    @Configurable(value="https", type=Type.DYNAMIC)
    String scheme;
    @Configurable(value="mule", type=Type.DYNAMIC)
    String source;

    protected boolean canHandle(AgentTrackingNotification message) {
        return true;
    }

    protected boolean flush(Collection<AgentTrackingNotification> messages) {
        LOGGER.debug("Flushing %s notifications.", (Object)messages.size());
        if (this.transport == null) {
            throw new NullPointerException("The Http transport isn't initialized.");
        }
        boolean succeeded = this.transport.send(messages);
        if (succeeded) {
            LOGGER.debug("Flushed %s notifications.", (Object)messages.size());
        }
        return succeeded;
    }

    public void initialize() throws InitializationException {
        LOGGER.debug("Configuring the Http Internal Handler with values: " + this.toString());
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.addMixInAnnotations(AgentTrackingNotification.class, AgentTrackingNotificationMixin.class);
        }
        if (this.transport != null) {
            LOGGER.debug("Disposing the previous Http transport");
            this.transport.dispose();
        }
        LOGGER.debug("Creating a new Http transport");
        this.transport = new HttpTransport();
        this.transport.init();
        LOGGER.debug("Successfully configured the Http Internal Handler.");
        super.initialize();
    }

    public BufferConfiguration getBuffer() {
        if (this.buffer == null) {
            this.buffer = new DiscardingMessageBufferConfigurationFactory().create(60000L, 1000, BufferType.MEMORY, null);
        }
        return this.buffer;
    }

    public String toString() {
        return "EventTrackingHttpInternalHandler{, host='" + this.host + '\'' + ", port=" + this.port + ", path='" + this.path + '\'' + ", scheme='" + this.scheme + '\'' + ", source='" + this.source + '\'' + '}';
    }

    static class HttpMessage<T> {
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="data")
        private Collection<T> events;

        HttpMessage(Collection<T> events, String source) {
            this.events = events;
            this.source = source;
        }
    }

    private class HttpTransport
    implements Transport<AgentTrackingNotification> {
        private AsyncHttpClient httpClient;
        private URL url;
        private static final int CONNECTION_TIMEOUT = 10000;

        private HttpTransport() {
        }

        public void init() throws InitializationException {
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(EventTrackingHttpInternalHandler.this.host, EventTrackingHttpInternalHandler.this.port), 10000);
                this.url = new URL(EventTrackingHttpInternalHandler.this.scheme, EventTrackingHttpInternalHandler.this.host, EventTrackingHttpInternalHandler.this.port, EventTrackingHttpInternalHandler.this.path);
                DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder().setThreadPoolName("EventTracking_AsyncHttpClient").addChannelOption(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT).setConnectTimeout(10000);
                DefaultAsyncHttpClientConfig asyncHttpClientConfig = builder.build();
                this.httpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)asyncHttpClientConfig);
            }
            catch (Exception e) {
                LOGGER.error("Error initializing the HTTP Event Host: {} - Port: {}. Error: {}", (Object)EventTrackingHttpInternalHandler.this.host, (Object)EventTrackingHttpInternalHandler.this.port, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                throw new InitializationException("There was an error connecting to the service. Please review your settings.", e);
            }
        }

        public boolean send(Collection<AgentTrackingNotification> messages) {
            HttpMessage<AgentTrackingNotification> httpMessage = new HttpMessage<AgentTrackingNotification>(messages, EventTrackingHttpInternalHandler.this.source);
            String serialized = this.serialize(httpMessage);
            try {
                Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)this.httpClient.preparePost(this.url.toString()).addHeader((CharSequence)"Content-type", "application/json")).setBody(serialized)).execute().get();
                if (response.getStatusCode() != 200) {
                    LOGGER.error("The service  didn't accept the request. Sending {} events. Error: {} - {}", (Object)messages.size(), (Object)response.getStatusCode(), (Object)response.getStatusText());
                    LOGGER.debug(messages);
                    return false;
                }
                return true;
            }
            catch (InterruptedException e) {
                LOGGER.error("Error sending messages. Error: {}", (Object)EventTrackingHttpInternalHandler.this.host, (Object)EventTrackingHttpInternalHandler.this.port, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                return false;
            }
            catch (ExecutionException e) {
                LOGGER.error("Error sending messages. Error: {}", (Object)EventTrackingHttpInternalHandler.this.host, (Object)EventTrackingHttpInternalHandler.this.port, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                return false;
            }
        }

        public void dispose() {
            if (this.httpClient != null) {
                try {
                    this.httpClient.close();
                }
                catch (IOException e) {
                    LOGGER.error("The connection could not be closed.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOGGER.debug((Object)e);
                    throw new RuntimeException(e);
                }
            }
        }

        private String serialize(Object message) {
            try {
                return EventTrackingHttpInternalHandler.this.objectMapper.writeValueAsString(message);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error converting event tracking notification to json: {}", message.getClass(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                throw new RuntimeException(e);
            }
        }
    }
}

