/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.wrappers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.mulesoft.mule.munit.recording.commons.wrappers.RecordedMediaType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public abstract class RecordedTypedValue
implements KryoSerializable {
    private static final transient String TRANSFORM_SCRIPT;
    private static long bindingCounter;
    private RecordedMediaType mediaType;

    private RecordedTypedValue(RecordedMediaType mediaType) {
        this.mediaType = mediaType;
    }

    private RecordedTypedValue() {
    }

    @NotNull
    public RecordedMediaType getMediaType() {
        return this.mediaType;
    }

    @NotNull
    public static <T> RecordedTypedValue valueOf(@NotNull ExpressionLanguage expressionLanguage, @NotNull TypedValue<T> typedValue) {
        Objects.requireNonNull(expressionLanguage, "The expression language may not be null");
        Objects.requireNonNull(typedValue, "The typed value may not be null");
        RecordedMediaType mediaType = new RecordedMediaType(typedValue.getDataType().getMediaType());
        String bindingName = "binding" + Long.toUnsignedString(++bindingCounter);
        BindingContext context = BindingContext.builder().addBinding(bindingName, typedValue).build();
        String transformScript = TRANSFORM_SCRIPT + String.format("output application/java --- transform(%s)", bindingName);
        return RecordedTypedValue.valueOf(expressionLanguage.evaluate(transformScript, context).getValue(), mediaType);
    }

    protected static RecordedTypedValue valueOf(Object object, RecordedMediaType mediaType) {
        if (object instanceof Map) {
            return new RecordedTypedMap((Map)object, mediaType);
        }
        if (object instanceof List) {
            return new RecordedTypedList((List)object, mediaType);
        }
        return new RecordedTypedSimpleValue(String.valueOf(object), mediaType);
    }

    @NotNull
    public abstract Object getValue();

    public final boolean equals(Object object) {
        if (!(object instanceof RecordedTypedValue)) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        RecordedTypedValue that = (RecordedTypedValue)object;
        return Objects.equals(this.getMediaType(), that.getMediaType()) && Objects.equals(this.getValue(), that.getValue());
    }

    public final int hashCode() {
        return Objects.hash(this.getMediaType(), this.getValue());
    }

    @Override
    public void write(Kryo kryo, Output output) {
        kryo.writeObject(output, this.mediaType);
    }

    @Override
    public void read(Kryo kryo, Input input) {
        this.mediaType = kryo.readObject(input, RecordedMediaType.class);
    }

    static {
        try (InputStream stream = Objects.requireNonNull(RecordedTypedValue.class.getClassLoader().getResource("transform.dwl")).openStream();){
            StringBuilder builder = new StringBuilder();
            while (stream.available() > 0) {
                builder.append((char)stream.read());
            }
            TRANSFORM_SCRIPT = builder.toString();
        }
        catch (Exception cause) {
            throw new RuntimeException(cause);
        }
    }

    public static final class RecordedTypedMap
    extends RecordedTypedValue {
        private Map<Integer, Entry> content;

        private RecordedTypedMap(Map<String, Map<String, ?>> map, RecordedMediaType mediaType) {
            super(mediaType);
            this.content = new TreeMap<Integer, Entry>();
            for (String index : map.keySet()) {
                Map<String, ?> entry = map.get(index);
                String key = (String)entry.get("key");
                Object value = entry.get("value");
                Map attributes = entry.getOrDefault("attributes", null);
                Map namespace = entry.getOrDefault("namespace", Collections.emptyMap());
                String prefix = namespace.getOrDefault("prefix", null);
                String uri = namespace.getOrDefault("uri", null);
                this.content.put(Integer.parseInt(index), new Entry(new Key(key, attributes, prefix, uri), value));
            }
            this.content = Collections.unmodifiableMap(this.content);
        }

        private RecordedTypedMap() {
        }

        @Override
        @NotNull
        public Map<Integer, Entry> getValue() {
            return this.content;
        }

        public String toString() {
            String content = this.getValue().values().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
            if (!this.getMediaType().toString().equals("Media Type {}")) {
                return String.format("Typed Value {media type: %s, content: {%s}}", this.getMediaType(), content);
            }
            return String.format("Typed Value {content: {%s}}", content);
        }

        @Override
        public void write(Kryo kryo, Output output) {
            super.write(kryo, output);
            output.writeInt(this.content.size());
            for (Integer index : this.content.keySet()) {
                output.writeInt(index);
                kryo.writeObject(output, this.content.get(index));
            }
        }

        @Override
        public void read(Kryo kryo, Input input) {
            super.read(kryo, input);
            this.content = new TreeMap<Integer, Entry>();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.content.put(input.readInt(), kryo.readObject(input, Entry.class));
            }
            this.content = Collections.unmodifiableMap(this.content);
        }

        public static final class Entry
        implements KryoSerializable {
            private Key key;
            private RecordedTypedValue value;

            private Entry(Key key, Object value) {
                this.key = key;
                this.value = RecordedTypedValue.valueOf(value, new RecordedMediaType(MediaType.ANY));
            }

            private Entry() {
            }

            public Key getKey() {
                return this.key;
            }

            public RecordedTypedValue getValue() {
                return this.value;
            }

            public String toString() {
                if (this.getKey().getNamespaceUri().isPresent()) {
                    return String.format("Entry {key : %s, value : %s, namespace: %s}", this.getKey(), this.getValue(), this.getKey().getNamespaceUri().get());
                }
                return String.format("Entry {key : %s, value : %s}", this.getKey(), this.getValue());
            }

            public boolean equals(Object object) {
                if (!(object instanceof Entry)) {
                    return false;
                }
                if (object == this) {
                    return true;
                }
                Entry that = (Entry)object;
                return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
            }

            public int hashCode() {
                return Objects.hash(this.key, this.value);
            }

            @Override
            public void write(Kryo kryo, Output output) {
                kryo.writeObject(output, this.key);
                kryo.writeClassAndObject(output, this.value);
            }

            @Override
            public void read(Kryo kryo, Input input) {
                this.key = kryo.readObject(input, Key.class);
                this.value = (RecordedTypedValue)kryo.readClassAndObject(input);
            }
        }

        public static final class Key
        implements KryoSerializable {
            private String name;
            private Map<String, String> attributes;
            private String uri;
            private String prefix;

            public Key(@NotNull String name, Map<String, String> attributes, String namespacePrefix, String namespaceUri) throws IllegalArgumentException {
                if (name == null || "".equals(name)) {
                    throw new IllegalArgumentException("The name must not be empty");
                }
                this.name = name;
                this.prefix = namespacePrefix;
                this.uri = namespaceUri;
                this.attributes = new TreeMap<String, String>();
                if (attributes != null) {
                    this.attributes.putAll(attributes);
                }
                this.attributes = Collections.unmodifiableMap(this.attributes);
            }

            public Key(@NotNull String name) {
                this(name, null, null, null);
            }

            private Key() {
            }

            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public Map<String, String> getAttributes() {
                return this.attributes;
            }

            @NotNull
            public Optional<String> getNamespacePrefix() {
                return Optional.ofNullable(this.prefix);
            }

            @NotNull
            public Optional<String> getNamespaceUri() {
                return Optional.ofNullable(this.uri);
            }

            public String toString() {
                String namespace = this.getNamespacePrefix().isPresent() ? String.format("%s#", this.getNamespacePrefix().get()) : "";
                String name = this.getName();
                String attributes = this.getAttributes().isEmpty() ? "" : " @(" + this.getAttributes().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")) + ")";
                return namespace + name + attributes;
            }

            public boolean equals(Object object) {
                if (!(object instanceof Key)) {
                    return false;
                }
                if (object == this) {
                    return true;
                }
                Key that = (Key)object;
                return Objects.equals(this.name, that.name) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.uri, that.uri);
            }

            public int hashCode() {
                return Objects.hash(this.getName(), this.getAttributes(), this.getNamespacePrefix(), this.getNamespaceUri());
            }

            @Override
            public void write(Kryo kryo, Output output) {
                kryo.writeObject(output, this.name);
                kryo.writeObjectOrNull(output, (Object)this.prefix, String.class);
                kryo.writeObjectOrNull(output, (Object)this.uri, String.class);
                output.writeInt(this.attributes.size());
                for (String key : this.attributes.keySet()) {
                    kryo.writeObjectOrNull(output, (Object)key, String.class);
                    kryo.writeObjectOrNull(output, (Object)this.attributes.get(key), String.class);
                }
            }

            @Override
            public void read(Kryo kryo, Input input) {
                this.name = kryo.readObject(input, String.class);
                this.prefix = kryo.readObjectOrNull(input, String.class);
                this.uri = kryo.readObjectOrNull(input, String.class);
                this.attributes = new TreeMap<String, String>();
                int size = input.readInt();
                for (int i = 0; i < size; ++i) {
                    this.attributes.put(kryo.readObjectOrNull(input, String.class), kryo.readObjectOrNull(input, String.class));
                }
                this.attributes = Collections.unmodifiableMap(this.attributes);
            }
        }
    }

    public static final class RecordedTypedList
    extends RecordedTypedValue {
        private List<RecordedTypedValue> content;

        private RecordedTypedList(List<?> list, RecordedMediaType mediaType) {
            super(mediaType);
            this.content = new ArrayList<RecordedTypedValue>(list.size());
            list.forEach(value -> this.content.add(RecordedTypedList.valueOf(value, new RecordedMediaType(MediaType.ANY))));
            this.content = Collections.unmodifiableList(this.content);
        }

        private RecordedTypedList() {
        }

        @Override
        @NotNull
        public List<RecordedTypedValue> getValue() {
            return this.content;
        }

        public String toString() {
            String content = this.getValue().stream().map(Object::toString).collect(Collectors.joining(", "));
            if (!this.getMediaType().toString().equals("Media Type {}")) {
                return String.format("Typed Value {media type: %s, content: [%s]}", this.getMediaType(), content);
            }
            return String.format("Typed Value {content: [%s]}", content);
        }

        @Override
        public void write(Kryo kryo, Output output) {
            super.write(kryo, output);
            output.writeInt(this.content.size());
            this.content.forEach(value -> kryo.writeClassAndObject(output, value));
        }

        @Override
        public void read(Kryo kryo, Input input) {
            super.read(kryo, input);
            int size = input.readInt();
            this.content = new ArrayList<RecordedTypedValue>(size);
            for (int i = 0; i < size; ++i) {
                this.content.add((RecordedTypedValue)kryo.readClassAndObject(input));
            }
            this.content = Collections.unmodifiableList(this.content);
        }
    }

    public static final class RecordedTypedSimpleValue
    extends RecordedTypedValue {
        private String content;

        private RecordedTypedSimpleValue(String script, RecordedMediaType mediaType) {
            super(mediaType);
            this.content = script;
        }

        private RecordedTypedSimpleValue() {
        }

        @Override
        @NotNull
        public String getValue() {
            return this.content;
        }

        public String toString() {
            if (!this.getMediaType().toString().equals("Media Type {}")) {
                return String.format("Typed Value {media type: %s, content: \"%s\"}", this.getMediaType(), this.getValue());
            }
            return String.format("Typed Value {content: \"%s\"}", this.getValue());
        }

        @Override
        public void write(Kryo kryo, Output output) {
            super.write(kryo, output);
            kryo.writeObject(output, this.content);
        }

        @Override
        public void read(Kryo kryo, Input input) {
            super.read(kryo, input);
            this.content = kryo.readObject(input, String.class);
        }
    }
}

