/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.wrappers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.mulesoft.mule.munit.recording.commons.wrappers.RecordedError;
import com.mulesoft.mule.munit.recording.commons.wrappers.RecordedMessage;
import com.mulesoft.mule.munit.recording.commons.wrappers.RecordedTypedValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;

public class RecordedEvent
implements KryoSerializable {
    private RecordedMessage message;
    private RecordedError error;
    private Map<String, RecordedTypedValue> variables;
    private String correlationId;

    public RecordedEvent(@NotNull ExpressionLanguage expressionLanguage, @NotNull Event event) {
        Objects.requireNonNull(event, "The event may not be null");
        this.message = new RecordedMessage(expressionLanguage, event.getMessage());
        this.error = event.getError().map(RecordedError::new).orElse(null);
        this.variables = new LinkedHashMap<String, RecordedTypedValue>();
        for (String key : event.getVariables().keySet()) {
            this.variables.put(key, RecordedTypedValue.valueOf(expressionLanguage, (TypedValue)event.getVariables().get(key)));
        }
        this.variables = Collections.unmodifiableMap(this.variables);
        this.correlationId = event.getCorrelationId();
    }

    private RecordedEvent() {
    }

    @NotNull
    public RecordedMessage getMessage() {
        return this.message;
    }

    @NotNull
    public Optional<RecordedError> getError() {
        return Optional.ofNullable(this.error);
    }

    @NotNull
    public Map<String, RecordedTypedValue> getVariables() {
        return this.variables;
    }

    @NotNull
    public String getCorrelationId() {
        return this.correlationId;
    }

    public String toString() {
        return "Event {" + Arrays.asList(String.format("message: %s", this.getMessage()), this.getError().map(error -> String.format("error: %s", error)).orElse(null), this.getVariables().isEmpty() ? null : "variables: {" + this.getVariables().entrySet().stream().map(entry -> String.format("\"%s\": %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")) + "}", String.format("correlation id: %s", this.getCorrelationId())).parallelStream().filter(Objects::nonNull).collect(Collectors.joining(", ")) + "}";
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecordedEvent)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        RecordedEvent that = (RecordedEvent)object;
        return Objects.equals(this.message, that.message) && Objects.equals(this.error, that.error) && Objects.equals(this.variables, that.variables) && Objects.equals(this.correlationId, that.correlationId);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.error, this.variables, this.correlationId);
    }

    @Override
    public void write(Kryo kryo, Output output) {
        kryo.writeObject(output, this.message);
        kryo.writeObjectOrNull(output, (Object)this.error, RecordedError.class);
        output.writeInt(this.variables.size());
        this.variables.forEach((key, value) -> {
            kryo.writeObject(output, key);
            kryo.writeClassAndObject(output, value);
        });
        kryo.writeObject(output, this.correlationId);
    }

    @Override
    public void read(Kryo kryo, Input input) {
        this.message = kryo.readObject(input, RecordedMessage.class);
        this.error = kryo.readObjectOrNull(input, RecordedError.class);
        this.variables = new LinkedHashMap<String, RecordedTypedValue>();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.variables.put(kryo.readObject(input, String.class), (RecordedTypedValue)kryo.readClassAndObject(input));
        }
        this.variables = Collections.unmodifiableMap(this.variables);
        this.correlationId = kryo.readObject(input, String.class);
    }
}

