/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.wrappers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;

public class RecordedError
implements KryoSerializable {
    private String cause;
    private String description;
    private String id;

    RecordedError(@NotNull Error error) {
        Throwable cause = Objects.requireNonNull(error, "The error may not be null").getCause();
        if (cause != null) {
            this.cause = cause.getClass().getName();
            this.description = cause.getMessage();
        } else {
            this.cause = null;
            this.description = null;
        }
        ErrorType errorType = error.getErrorType();
        this.id = errorType != null ? errorType.getNamespace() + ":" + errorType.getIdentifier() : null;
    }

    private RecordedError() {
    }

    @NotNull
    public Optional<String> getCause() {
        return Optional.ofNullable(this.cause);
    }

    @NotNull
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @NotNull
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public String toString() {
        return "Error {" + Arrays.asList(this.getId().map(id -> String.format("id: \"%s\"", id)).orElse(null), this.getCause().map(cause -> String.format("cause: %s", cause)).orElse(null), this.getDescription().map(description -> String.format("description: \"%s\"", description)).orElse(null)).parallelStream().filter(Objects::nonNull).collect(Collectors.joining(", ")) + "}";
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecordedError)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        RecordedError that = (RecordedError)object;
        return Objects.equals(this.cause, that.cause) && Objects.equals(this.description, that.description) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.cause, this.description, this.id);
    }

    @Override
    public void write(Kryo kryo, Output output) {
        kryo.writeObjectOrNull(output, (Object)this.cause, String.class);
        kryo.writeObjectOrNull(output, (Object)this.description, String.class);
        kryo.writeObjectOrNull(output, (Object)this.id, String.class);
    }

    @Override
    public void read(Kryo kryo, Input input) {
        this.cause = kryo.readObjectOrNull(input, String.class);
        this.description = kryo.readObjectOrNull(input, String.class);
        this.id = kryo.readObjectOrNull(input, String.class);
    }
}

