/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.wrappers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class Container
implements KryoSerializable {
    private static long counter;
    private final Map<Key, Object> content = new TreeMap<Key, Object>();
    private Type type;
    private long id;

    public Container(@NotNull Type type, Entry<?> ... entries) {
        this(type, counter++, entries);
    }

    public Container(@NotNull Type type, long id, Entry<?> ... entries) {
        this.type = Objects.requireNonNull(type, "The type may not be null");
        Arrays.stream(Objects.requireNonNull(entries, "The entries may not be null")).forEach(entry -> this.put(entry.key, entry.value));
        this.id = id;
    }

    private Container() {
    }

    @NotNull
    public Type type() {
        return this.type;
    }

    public long id() {
        return this.id;
    }

    @NotNull
    public <T> T get(@NotNull Key key) throws NoSuchElementException {
        if (this.content.containsKey((Object)Objects.requireNonNull(key, "The key may not be null"))) {
            return (T)this.content.get((Object)key);
        }
        throw new NoSuchElementException("The container does not have any element under the given key: " + (Object)((Object)key));
    }

    public int size() {
        return this.content.size();
    }

    @NotNull
    public Set<Key> keys() {
        return this.content.keySet();
    }

    public String toString() {
        return String.format("{type: %s, content: {%s}}", new Object[]{this.type, this.content.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "))});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Container)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Container that = (Container)object;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.content});
    }

    private <T> void put(Key key, T value) throws IllegalArgumentException {
        if (!this.content.containsKey((Object)key)) {
            this.content.put(key, value);
            return;
        }
        throw new IllegalArgumentException(String.format("There are multiple values under the key %s: %s & %s", new Object[]{key, this.content.get((Object)key), value}));
    }

    @Override
    public void write(Kryo kryo, Output output) {
        kryo.writeObject(output, (Object)this.type);
        output.writeLong(this.id);
        output.writeInt(this.size());
        for (Key key : this.keys()) {
            kryo.writeObject(output, (Object)key);
            kryo.writeClassAndObject(output, this.content.get((Object)key));
        }
    }

    @Override
    public void read(Kryo kryo, Input input) {
        this.type = kryo.readObject(input, Type.class);
        this.id = input.readLong();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.content.put(kryo.readObject(input, Key.class), kryo.readClassAndObject(input));
        }
    }

    public static enum Type {
        AFTER,
        BEFORE,
        CHECK,
        ERROR,
        NO,
        OK,
        YES;

    }

    public static class Entry<T> {
        public final Key key;
        public final T value;

        public Entry(@NotNull Key key, @NotNull T value) {
            this.key = Objects.requireNonNull(key, "The key may not be null");
            this.value = Objects.requireNonNull(value, "The value may not be null");
        }
    }

    public static enum Key {
        EVENT,
        EVENT_ID,
        FLOW,
        MESSAGE,
        PROCESSOR,
        THROWABLE;

    }
}

