/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.net;

import com.mulesoft.mule.munit.recording.commons.net.Connection;
import com.mulesoft.mule.munit.recording.commons.net.Connector;
import com.mulesoft.mule.munit.recording.commons.net.Listener;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
extends Connector {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private final ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor();
    private ServerSocket socket;

    public Server(Listener ... listeners) {
        super(listeners);
    }

    @Override
    public void connect(int port) throws IOException {
        this.socket = new ServerSocket(port);
        this.threadPool.scheduleWithFixedDelay(this::accept, 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        super.close();
        this.threadPool.shutdown();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException cause) {
                LOGGER.error("There was a problem while closing the socket", cause);
            }
            this.socket = null;
        }
        try {
            this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException cause) {
            LOGGER.error("There was a problem while closing the server", cause);
        }
    }

    private void accept() {
        block2: {
            try {
                new Connection(this, this.socket.accept());
            }
            catch (IOException cause) {
                if (!this.threadPool.isShutdown()) break block2;
                LOGGER.warn("There was a problem while connecting to a client", cause);
            }
        }
    }
}

