/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.net;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.mulesoft.mule.munit.recording.commons.KryoUtils;
import com.mulesoft.mule.munit.recording.commons.net.Connector;
import java.io.IOException;
import java.net.Socket;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor();
    private final Connector connector;
    private final Socket socket;
    private final Input input;
    private final Output output;

    public Connection(@NotNull Connector connector, @NotNull Socket socket) throws IOException {
        this.connector = Objects.requireNonNull(connector, "The connector may not be null");
        this.socket = Objects.requireNonNull(socket, "The socket may not be null");
        this.output = new Output(socket.getOutputStream(), 0x1FFFFF);
        this.input = new Input(socket.getInputStream(), 0x1FFFFF);
        this.threadPool.scheduleWithFixedDelay(this::read, 10L, 10L, TimeUnit.MILLISECONDS);
        connector.opened(this);
    }

    public void send(Object object) {
        if (!this.threadPool.isShutdown()) {
            this.threadPool.execute(() -> this.write(object));
        }
    }

    void close() {
        this.connector.closed(this);
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException cause) {
            LOGGER.error("There was a problem while closing the connection", cause);
        }
        try {
            this.output.close();
            this.input.close();
            this.socket.close();
        }
        catch (IOException cause) {
            LOGGER.error("There was a problem closing the socket", cause);
        }
    }

    private void write(Object object) {
        KryoUtils.write(this.output, object);
    }

    private void read() {
        try {
            if (this.input.available() > 0) {
                this.connector.received(this, KryoUtils.read(this.input));
            }
        }
        catch (IOException cause) {
            LOGGER.warn("There was a problem reading an object, retrying", cause);
        }
    }
}

