/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.vcs;

import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.mule.tooling.platform.PlatformPlugin;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

@Singleton
public class IgnoreResourceManager {
    private List<ProjectComponentExtension> extension = this.loadExtensions();

    public static IgnoreResourceManager getInstance() {
        return (IgnoreResourceManager)ContextInjectionFactory.make(IgnoreResourceManager.class, (IEclipseContext)PlatformPlugin.getServiceContext());
    }

    protected List<ProjectComponentExtension> loadExtensions() {
        return IExtensionPointReader.create(ProjectComponentExtension.class).readAll();
    }

    public boolean shouldIgnore(IPath path) {
        return this.extension.stream().filter(ex -> {
            String pattern = ex.getPattern();
            return ex.getEnabled() != false && Arrays.asList(path.segments()).contains(pattern);
        }).findFirst().isPresent();
    }

    @ExtensionPoint(extensionPointId="org.eclipse.team.core.ignore")
    public static class ProjectComponentExtension {
        @ExtensionAttribute(attributeName="pattern")
        private String pattern;
        @ExtensionAttribute(attributeName="enabled")
        private Boolean enabled;

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }
}

