/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.utils;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.platform.PlatformPlugin;

public class SafeRunner {
    public static IStatus exec(VoidCallable runnable, String operationDescription) {
        try {
            runnable.call();
        }
        catch (Exception e) {
            SafeRunner.handleException(operationDescription, e);
            return PlatformPlugin.createErrorStatus("Error while doing " + operationDescription, e);
        }
        return Status.OK_STATUS;
    }

    public static <T> T exec(Callable<T> call, T defaultReturn, String operationDescription) {
        try {
            return call.call();
        }
        catch (Exception e) {
            SafeRunner.handleException(operationDescription, e);
            return defaultReturn;
        }
    }

    protected static void handleException(String operationDescription, Exception e) {
        PlatformPlugin.logError("Error while '" + operationDescription + "'", e);
    }

    protected static void handleException(Exception e) {
        PlatformPlugin.logError("Unexpected error.", e);
    }

    @FunctionalInterface
    public static interface VoidCallable {
        public void call() throws Exception;
    }
}

