/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.utils;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.mule.tooling.platform.utils.SafeRunner;

public class ProjectHelper {
    public static boolean isJavaProject(IProject project) {
        return ProjectHelper.hasNature(project, "org.eclipse.jdt.core.javanature");
    }

    public static void addBuilderToDescription(IProjectDescription desc, String builderId) {
        ICommand[] commands = desc.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName(builderId);
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
    }

    public static boolean hasNature(IProject project, String natureId) {
        return SafeRunner.exec(() -> {
            if (project != null && project.isAccessible()) {
                String[] ids;
                IProjectDescription description = project.getDescription();
                String[] stringArray = ids = description.getNatureIds();
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (natureId.equals(id)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            return false;
        }, false, "Calculating Nature");
    }

    public static String[] getNatures(IProject project) {
        return SafeRunner.exec(() -> {
            if (project != null && project.isAccessible()) {
                IProjectDescription description = project.getDescription();
                return description.getNatureIds();
            }
            return new String[0];
        }, new String[0], "Retrieving Nature");
    }

    public static void addNaturesToProjectDescription(IProjectDescription description, String ... natureIds) {
        String[] ids = description.getNatureIds();
        String[] newIds = new String[ids.length + natureIds.length];
        System.arraycopy(ids, 0, newIds, natureIds.length, ids.length);
        int i = 0;
        while (i < natureIds.length) {
            newIds[i] = natureIds[i];
            ++i;
        }
        description.setNatureIds(newIds);
    }
}

