/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.utils;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Debouncer
implements Runnable {
    private ScheduledFuture<?> future = null;
    private final ScheduledExecutorService executorService;
    private final Runnable target;
    private final Duration debounceDelay;

    public Debouncer(Runnable target, Duration debounceDelay) {
        this.target = Objects.requireNonNull(target, "target");
        this.debounceDelay = Objects.requireNonNull(debounceDelay, "debounceDelay");
        this.executorService = Debouncer.newDaemonScheduledExecutorService();
    }

    private static ScheduledExecutorService newDaemonScheduledExecutorService() {
        return Executors.newSingleThreadScheduledExecutor(Debouncer::makeDaemonThread);
    }

    private static Thread makeDaemonThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    }

    @Override
    public void run() {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(false);
        }
        this.future = this.executorService.schedule(this.target, this.debounceDelay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Duration getDebounceDelay() {
        return this.debounceDelay;
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }
}

