/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.locking;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.platform.component.IPlatformComponent;
import org.mule.tooling.platform.component.PlatformComponentManager;
import org.mule.tooling.platform.events.DefaultProjectEventListener;
import org.mule.tooling.platform.events.ProjectEventManager;
import org.mule.tooling.platform.locking.ILock;

public class LockingService
implements IPlatformComponent {
    private ConcurrentHashMap<IProject, ConcurrentHashMap<ILock, ReentrantReadWriteLock>> locks = new ConcurrentHashMap();

    public static LockingService getInstance() {
        return PlatformComponentManager.getPlatformComponent(LockingService.class).get();
    }

    @Override
    public void wire() {
        ProjectEventManager.getInstance().addListener(new DefaultProjectEventListener(){

            @Override
            public void onProjectClosed(IProject project) {
                LockingService.this.locks.remove(project);
            }
        });
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.locks.clear();
    }

    public <T> T call(IProject project, ILock lockName, Callable<T> caller, LockType lockType) throws Exception {
        ReentrantReadWriteLock lock = this.getLock(project, lockName);
        try {
            if (lockType == LockType.READ) {
                lock.readLock().lock();
            } else {
                lock.writeLock().lock();
            }
            T t = caller.call();
            return t;
        }
        finally {
            if (lockType == LockType.READ) {
                lock.readLock().unlock();
            } else {
                lock.writeLock().unlock();
            }
        }
    }

    private ReentrantReadWriteLock getLock(IProject project, ILock lockName) {
        ConcurrentHashMap projectLocks = this.locks.computeIfAbsent(project, key -> new ConcurrentHashMap());
        ReentrantReadWriteLock lock = projectLocks.computeIfAbsent(lockName, key -> new ReentrantReadWriteLock());
        return lock;
    }

    public void run(IProject project, ILock lockName, LockRunnable caller, LockType lockType) throws CoreException {
        ReentrantReadWriteLock lock = this.getLock(project, lockName);
        try {
            if (lockType == LockType.READ) {
                lock.readLock().lock();
            } else {
                lock.writeLock().lock();
            }
            caller.run();
        }
        finally {
            if (lockType == LockType.READ) {
                lock.readLock().unlock();
            } else {
                lock.writeLock().unlock();
            }
        }
    }

    public void schedule(final IProject project, final ILock lockName, final IJobFunction caller, final LockType lockType, String jobName) {
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Waiting on " + String.valueOf(lockName) + " to be released", 0);
                ReentrantReadWriteLock lock = LockingService.this.getLock(project, lockName);
                try {
                    if (lockType == LockType.READ) {
                        lock.readLock().lock();
                    } else {
                        lock.writeLock().lock();
                    }
                    IStatus iStatus = caller.run(monitor);
                    return iStatus;
                }
                finally {
                    if (lockType == LockType.READ) {
                        lock.readLock().unlock();
                    } else {
                        lock.writeLock().unlock();
                    }
                }
            }
        };
        job.schedule();
    }

    @FunctionalInterface
    public static interface LockRunnable {
        public void run() throws CoreException;
    }

    public static enum LockType {
        WRITE,
        READ;

    }
}

