/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.indexer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.background.BackgroundRequest;
import org.mule.tooling.core.background.BackgroundRequestExecutor;
import org.mule.tooling.core.background.BatchProcessor;
import org.mule.tooling.core.background.ExecutableRequest;
import org.mule.tooling.core.background.SimpleExecutableRequestProcessor;
import org.mule.tooling.core.background.SimpleRequest;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.platform.PlatformPlugin;
import org.mule.tooling.platform.builder.events.DependencyRemovedEvent;
import org.mule.tooling.platform.component.IProjectComponent;
import org.mule.tooling.platform.component.ProjectComponentManager;
import org.mule.tooling.platform.events.DefaultProjectEventListener;
import org.mule.tooling.platform.events.IEventListenerHandler;
import org.mule.tooling.platform.events.IProjectEventListener;
import org.mule.tooling.platform.events.ProjectEventManager;
import org.mule.tooling.platform.indexer.ContainerType;
import org.mule.tooling.platform.indexer.DocumentContent;
import org.mule.tooling.platform.indexer.DocumentIndexKey;
import org.mule.tooling.platform.indexer.IDocumentIndexer;
import org.mule.tooling.platform.indexer.IIndexClassifier;
import org.mule.tooling.platform.indexer.eventbus.IndexesRemovedEvent;
import org.mule.tooling.platform.indexer.eventbus.PostIndexEvent;
import org.mule.tooling.platform.indexer.eventbus.PostJarIndexEvent;
import org.mule.tooling.platform.indexer.eventbus.PreIndexEvent;
import org.mule.tooling.platform.utils.ProjectHelper;
import org.mule.tooling.platform.utils.SafeRunner;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class DocumentIndexerServiceManager
implements IProjectComponent {
    private static final String FOR = " for  ";
    private static final String DELETING_INDEXES_ON = "Deleting indexes on ";
    private static final String INDEXING_PROJECT = "Indexing project: ";
    private IProject project;
    private IEventListenerHandler projectEventListenerHandler;
    private List<Pair<DocumentIndexKey, DocumentContent>> indexes;
    private Map<IPath, List<DocumentIndexKey>> containers;
    private ReentrantReadWriteLock accessLock = new ReentrantReadWriteLock();
    private List<DocumentIndexerExtension> indexerExtensions;
    private BackgroundRequestExecutor<ExecutableRequest> backgroundRequestExecutor;

    public static DocumentIndexerServiceManager getInstance(IProject project) {
        return ProjectComponentManager.projectComponentWith(project, DocumentIndexerServiceManager.class);
    }

    public static DocumentIndexerServiceManager getInstanceIfAvailable(IProject project) {
        return ProjectComponentManager.projectComponentWith(project, DocumentIndexerServiceManager.class);
    }

    public DocumentIndexerServiceManager(IProject project) {
        this.project = project;
        this.containers = new HashMap<IPath, List<DocumentIndexKey>>();
        this.indexes = new ArrayList<Pair<DocumentIndexKey, DocumentContent>>();
        this.indexerExtensions = this.loadExtensions();
        this.backgroundRequestExecutor = BackgroundRequestExecutor.builder((String)"Indexing Request Executor", (BatchProcessor)new SimpleExecutableRequestProcessor()).buildSimple(true, 10L);
    }

    protected List<DocumentIndexerExtension> loadExtensions() {
        return IExtensionPointReader.create(DocumentIndexerExtension.class).readAll();
    }

    public List<Pair<DocumentIndexKey, DocumentContent>> getIndexByClassifier(IIndexClassifier classifier) {
        return this.indexes.stream().filter(index -> ((DocumentIndexKey)index.getLeft()).getClassifier().accepts(classifier)).collect(Collectors.toList());
    }

    @Override
    public void wire() {
        this.projectEventListenerHandler = ProjectEventManager.getInstance().addListener(this.project, (IProjectEventListener)new DefaultProjectEventListener(){

            @Override
            public void onFileRemoved(IProject project, IFile file) {
                DocumentIndexerServiceManager.this.backgroundRequestExecutor.submit((BackgroundRequest)new SimpleRequest(DocumentIndexerServiceManager.DELETING_INDEXES_ON + project.getName() + DocumentIndexerServiceManager.FOR + String.valueOf(file.getFullPath()), DocumentIndexerServiceManager.this.deleteFileIndex(file.getFullPath())));
            }

            @Override
            public void onFileChanged(IProject project, IFile file) {
                DocumentIndexerServiceManager.this.backgroundRequestExecutor.submit((BackgroundRequest)new SimpleRequest(DocumentIndexerServiceManager.INDEXING_PROJECT + project.getName() + DocumentIndexerServiceManager.FOR + String.valueOf(file.getFullPath()), DocumentIndexerServiceManager.this.indexFiles(Collections.singletonList(file), Collections.emptyList())));
            }

            @Override
            public void onFileAdded(IProject project, IFile file) {
                DocumentIndexerServiceManager.this.backgroundRequestExecutor.submit((BackgroundRequest)new SimpleRequest(DocumentIndexerServiceManager.INDEXING_PROJECT + project.getName() + DocumentIndexerServiceManager.FOR + String.valueOf(file.getFullPath()), DocumentIndexerServiceManager.this.indexFiles(Collections.singletonList(file), Collections.emptyList())));
            }

            @Override
            public void onClasspathEntryAdded(IProject project, IPackageFragmentRoot affectedJar, MavenDependency entry) {
                DocumentIndexerServiceManager.this.backgroundRequestExecutor.submit((BackgroundRequest)new SimpleRequest(DocumentIndexerServiceManager.INDEXING_PROJECT + project.getName() + DocumentIndexerServiceManager.FOR + String.valueOf(affectedJar.getPath()), DocumentIndexerServiceManager.this.indexFiles(Collections.emptyList(), Collections.singletonList(affectedJar))));
            }

            @Override
            public void onClasspathEntryRemoved(IProject project, IPackageFragmentRoot affectedJar, MavenDependency entry) {
                DocumentIndexerServiceManager.this.backgroundRequestExecutor.submit((BackgroundRequest)new SimpleRequest(DocumentIndexerServiceManager.DELETING_INDEXES_ON + project.getName() + DocumentIndexerServiceManager.FOR + String.valueOf(affectedJar.getPath()), DocumentIndexerServiceManager.this.deleteFileIndex(affectedJar.getPath())));
            }

            @Override
            public void onProjectClosed(IProject project) {
                DocumentIndexerServiceManager.this.backgroundRequestExecutor.cancel();
            }
        });
    }

    private void removeAllIndexes(IPath containerPath) {
        List<DocumentIndexKey> toRemove = this.containers.remove(containerPath);
        this.removeAllIndexes(toRemove);
    }

    private void indexFile(IFile file) {
        if (file.isHidden()) {
            return;
        }
        Optional<IPackageFragmentRoot> container = this.findContainer(file);
        if (container.isPresent()) {
            IPackageFragmentRoot fragmentRoot = container.get();
            this.indexFile(file, fragmentRoot);
        }
    }

    private void indexFile(IFile file, IPackageFragmentRoot fragmentRoot) {
        DocumentContent documentContent = new DocumentContent(file.getProject(), file.getLocation(), (IStorage)file, fragmentRoot.getResource().getLocation(), ContainerType.Project);
        List<IDocumentIndexer> indexers = this.findIndexer(documentContent);
        PlatformPlugin.getEventBus().fireEvent((IEvent)new PreIndexEvent(documentContent, this.project));
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (IDocumentIndexer indexer : indexers) {
            List<DocumentIndexKey> indexResult = indexer.index(documentContent);
            for (DocumentIndexKey documentIndexKey : indexResult) {
                Pair pair2 = new Pair((Object)documentIndexKey, (Object)documentContent);
                result.add(pair2);
            }
        }
        this.containers.put(file.getFullPath(), result.stream().map(pair -> (DocumentIndexKey)pair.getLeft()).collect(Collectors.toList()));
        this.indexes.addAll(result);
        PlatformPlugin.getEventBus().fireEvent((IEvent)new PostIndexEvent(documentContent, this.project));
    }

    private Optional<IPackageFragmentRoot> findContainer(IFile file) {
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = this.getJavaProject().getAllPackageFragmentRoots();
            Optional<IPackageFragmentRoot> container = Stream.of(allPackageFragmentRoots).filter(fr -> {
                try {
                    if (fr.getKind() == 1) {
                        IPath makeRelativeTo = file.getFullPath().makeRelativeTo(fr.getResource().getFullPath());
                        return makeRelativeTo.segmentCount() > 0;
                    }
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }).findFirst();
            return container;
        }
        catch (JavaModelException javaModelException) {
            return Optional.empty();
        }
    }

    private void indexJar(IPackageFragmentRoot fragment) throws JavaModelException {
        ArrayList<Pair<DocumentIndexKey, DocumentContent>> result = new ArrayList<Pair<DocumentIndexKey, DocumentContent>>();
        if (this.packageFragmentIsAccessible((IJavaElement)fragment)) {
            IJavaElement[] packages = fragment.getChildren();
            result.addAll(this.indexJarResources(fragment.getNonJavaResources(), fragment));
            IJavaElement[] iJavaElementArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment packageFragment;
                IJavaElement packageElement = iJavaElementArray[n2];
                if (packageElement instanceof IPackageFragment && this.packageFragmentIsAccessible((IJavaElement)(packageFragment = (IPackageFragment)packageElement))) {
                    result.addAll(this.indexJarResources(packageFragment.getNonJavaResources(), fragment));
                }
                ++n2;
            }
            this.indexes.addAll(result);
            List indexes = result.stream().map(pair -> (DocumentIndexKey)pair.getLeft()).collect(Collectors.toList());
            this.containers.put(fragment.getPath(), indexes);
            PlatformPlugin.getEventBus().fireEvent((IEvent)new PostJarIndexEvent(this.project, fragment));
        }
    }

    private boolean packageFragmentIsAccessible(IJavaElement packageElement) {
        return packageElement.exists() && packageElement.getJavaProject().getProject().isAccessible();
    }

    private List<Pair<DocumentIndexKey, DocumentContent>> indexJarResources(Object[] resources, IPackageFragmentRoot fragment) throws JavaModelException {
        ArrayList<Pair<DocumentIndexKey, DocumentContent>> result = new ArrayList<Pair<DocumentIndexKey, DocumentContent>>();
        Object[] objectArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Object resource = objectArray[n2];
            if (resource instanceof IJarEntryResource) {
                IJarEntryResource jarEntry = (IJarEntryResource)resource;
                boolean isFile = jarEntry.isFile();
                if (isFile) {
                    DocumentContent documentContent = new DocumentContent(this.project, jarEntry.getFullPath(), (IStorage)jarEntry, fragment.getPath(), ContainerType.Jar);
                    List<IDocumentIndexer> indexers = this.findIndexer(documentContent);
                    PlatformPlugin.getEventBus().fireEvent((IEvent)new PreIndexEvent(documentContent, this.project));
                    for (IDocumentIndexer indexer : indexers) {
                        List<DocumentIndexKey> indexes = indexer.index(documentContent);
                        for (DocumentIndexKey documentIndexKey : indexes) {
                            result.add((Pair<DocumentIndexKey, DocumentContent>)new Pair((Object)documentIndexKey, (Object)documentContent));
                        }
                    }
                    PlatformPlugin.getEventBus().fireEvent((IEvent)new PostIndexEvent(documentContent, this.project));
                } else {
                    result.addAll(this.indexJarResources(jarEntry.getChildren(), fragment));
                }
            }
            ++n2;
        }
        return result;
    }

    List<IDocumentIndexer> findIndexer(DocumentContent documentContent) {
        if (documentContent.getPath() == null) {
            return Collections.emptyList();
        }
        return this.indexerExtensions.stream().filter(ext -> ext.getIndexer().handles(documentContent)).map(ext -> ext.getIndexer()).collect(Collectors.toList());
    }

    @Override
    public void start() {
        if (ProjectHelper.isJavaProject(this.project)) {
            HashSet filesToIndex = new HashSet();
            ArrayList<IPackageFragmentRoot> jarsToIndex = new ArrayList<IPackageFragmentRoot>();
            SafeRunner.exec(() -> {
                IPackageFragmentRoot[] rootFragments;
                IPackageFragmentRoot[] iPackageFragmentRootArray = rootFragments = this.getJavaProject().getAllPackageFragmentRoots();
                int n = rootFragments.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                    SafeRunner.exec(() -> {
                        this.accessLock.writeLock().lock();
                        try {
                            int kind = fragmentRoot.getKind();
                            if (kind == 1) {
                                this.collectFilesInPackage(fragmentRoot, (Set<IFile>)filesToIndex);
                            } else {
                                jarsToIndex.add(fragmentRoot);
                            }
                        }
                        finally {
                            this.accessLock.writeLock().unlock();
                        }
                    }, "Indexing Classpath Entry " + fragmentRoot.getPath().toOSString());
                    ++n2;
                }
            }, "Indexing Jars for" + this.project.getName());
            this.backgroundRequestExecutor.submit((BackgroundRequest)new SimpleRequest(INDEXING_PROJECT + this.project.getName(), this.indexFiles(new ArrayList<IFile>(filesToIndex), jarsToIndex)));
        }
    }

    private ExecutableRequest.Action<SimpleRequest> indexFiles(List<IFile> filesToIndex, List<IPackageFragmentRoot> packageRoots) {
        return (monitor, request) -> {
            if (this.project.isAccessible()) {
                this.accessLock.writeLock().lock();
                try {
                    for (IFile file : filesToIndex) {
                        this.removeAllIndexes(file.getFullPath());
                        SafeRunner.exec(() -> this.indexFile(file), "Indexing " + String.valueOf(file.getFullPath()));
                    }
                    for (IPackageFragmentRoot fragmentRoot : packageRoots) {
                        this.removeAllIndexes(fragmentRoot.getPath());
                        if (!this.packageFragmentIsAccessible((IJavaElement)fragmentRoot)) continue;
                        SafeRunner.exec(() -> this.indexJar(fragmentRoot), "Indexing " + String.valueOf(fragmentRoot.getPath()));
                    }
                }
                finally {
                    this.accessLock.writeLock().unlock();
                }
            }
        };
    }

    private ExecutableRequest.Action<SimpleRequest> deleteFileIndex(IPath path) {
        return (monitor, request) -> {
            ReentrantReadWriteLock.WriteLock writeLock = this.accessLock.writeLock();
            writeLock.lock();
            try {
                this.removeAllIndexes(path);
                PlatformPlugin.getEventBus().fireEvent((IEvent)new IndexesRemovedEvent(Arrays.asList(path), this.project));
            }
            finally {
                writeLock.unlock();
            }
        };
    }

    private void collectFilesInPackage(IPackageFragmentRoot fragment, Set<IFile> filesToIndex) throws JavaModelException {
        IJavaElement[] packages;
        Object[] nonJavaResources;
        Object[] objectArray = nonJavaResources = fragment.getNonJavaResources();
        int n = nonJavaResources.length;
        int n2 = 0;
        while (n2 < n) {
            Object resource = objectArray[n2];
            if (resource instanceof IResource) {
                this.indexResource((IResource)resource, filesToIndex);
            }
            ++n2;
        }
        IJavaElement[] iJavaElementArray = packages = fragment.getChildren();
        int n3 = packages.length;
        n = 0;
        while (n < n3) {
            IJavaElement packageFragment = iJavaElementArray[n];
            if (packageFragment instanceof IPackageFragment) {
                this.collectFilesInPackage((IPackageFragment)packageFragment, filesToIndex);
            }
            ++n;
        }
    }

    private void collectFilesInPackage(IPackageFragment parent, Set<IFile> filesToIndex) throws JavaModelException {
        IJavaElement[] packages;
        Object[] nonJavaResources;
        Object[] objectArray = nonJavaResources = parent.getNonJavaResources();
        int n = nonJavaResources.length;
        int n2 = 0;
        while (n2 < n) {
            Object resource = objectArray[n2];
            if (resource instanceof IResource) {
                this.indexResource((IResource)resource, filesToIndex);
            }
            ++n2;
        }
        IJavaElement[] iJavaElementArray = packages = parent.getChildren();
        int n3 = packages.length;
        n = 0;
        while (n < n3) {
            IJavaElement packageFragment = iJavaElementArray[n];
            if (packageFragment instanceof IPackageFragment) {
                this.collectFilesInPackage((IPackageFragment)packageFragment, filesToIndex);
            }
            ++n;
        }
    }

    private void indexResource(IResource resource, Set<IFile> filesToIndex) {
        if (resource instanceof IFile) {
            filesToIndex.add((IFile)resource);
        } else if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    this.indexResource(child, filesToIndex);
                    ++n2;
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("Error indexing " + folder.getLocation().toString() + " children"), (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        this.projectEventListenerHandler.unregister();
        try {
            this.backgroundRequestExecutor.stop();
        }
        catch (InterruptedException e) {
            MuleCorePlugin.logWarning((String)"Unexpected error stopping backgroundRequestExecutor", (Throwable)e);
        }
        LinkedList<MavenDependency> depsToRemove = new LinkedList<MavenDependency>();
        LinkedList<IPath> resourcesToRemove = new LinkedList<IPath>();
        for (Pair<DocumentIndexKey, DocumentContent> pair : this.indexes) {
            DocumentContent content = (DocumentContent)pair.getRight();
            if (content.getContainerType() == ContainerType.Project) {
                IPath path = content.getPath();
                IPath location = this.project.getLocation();
                IPath relativePath = path.makeRelativeTo(location);
                IFile file = this.project.getFile(relativePath);
                resourcesToRemove.add(file.getLocation());
                continue;
            }
            MavenDependency mavenDependency = MavenUtils.getDependencyFromPath((File)content.getContainer().toFile());
            depsToRemove.add(mavenDependency);
        }
        if (!resourcesToRemove.isEmpty()) {
            PlatformPlugin.getEventBus().fireEvent((IEvent)new IndexesRemovedEvent(resourcesToRemove, this.project));
        }
        if (!depsToRemove.isEmpty()) {
            PlatformPlugin.getEventBus().fireEvent((IEvent)new DependencyRemovedEvent(depsToRemove, this.project));
        }
        this.indexes.clear();
        this.containers.clear();
    }

    private void removeAllIndexes(List<DocumentIndexKey> toRemove) {
        if (toRemove == null) {
            return;
        }
        ArrayList<Pair<DocumentIndexKey, DocumentContent>> arrayList = new ArrayList<Pair<DocumentIndexKey, DocumentContent>>(this.indexes);
        for (DocumentIndexKey removeIndex : toRemove) {
            for (Pair<DocumentIndexKey, DocumentContent> pair : arrayList) {
                boolean removed;
                if (pair.getLeft() != removeIndex || (removed = this.indexes.remove(pair))) continue;
                MuleCorePlugin.logInfo((String)"[DocumentIndexerManager] Unable to delete index entry");
            }
        }
    }

    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @ExtensionPoint(extensionPointId="org.mule.project.documentIndexer")
    public static class DocumentIndexerExtension {
        @ExtensionAttribute(attributeName="class")
        private IDocumentIndexer indexer;

        public IDocumentIndexer getIndexer() {
            return this.indexer;
        }

        public void setIndexer(IDocumentIndexer indexer) {
            this.indexer = indexer;
        }
    }
}

