/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.indexer;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.platform.indexer.ContainerType;
import org.mule.tooling.platform.utils.SafeRunner;

public class DocumentContent {
    private IPath path;
    private IStorage content;
    private IPath container;
    private ContainerType containerType;
    private IProject project;

    public DocumentContent(IProject project, IPath path, IStorage content, IPath container, ContainerType containerType) {
        this.project = project;
        this.path = path;
        this.content = content;
        this.container = container;
        this.containerType = containerType;
    }

    public String getStringContent() {
        return (String)((Object)SafeRunner.exec(() -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream contents = this.content.getContents();){
                if (this.content instanceof IFile) {
                    return IOUtils.toString((InputStream)contents, (String)((IFile)this.content).getCharset());
                }
                return IOUtils.toString((InputStream)contents, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, "Reading content " + this.path.toString(), "Reading content " + this.path.toString() + ", full path:" + this.path.toFile().getAbsolutePath()));
    }

    public IProject getProject() {
        return this.project;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public IPath getPath() {
        return this.path;
    }

    public IStorage getContent() {
        return this.content;
    }

    public IPath getContainer() {
        return this.container;
    }
}

