/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.indexer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.platform.indexer.ContainerType;
import org.mule.tooling.platform.indexer.DocumentContent;
import org.mule.tooling.platform.indexer.IDocumentIndexer;

public abstract class AbstractDocumentIndexer
implements IDocumentIndexer {
    @Override
    public boolean handles(DocumentContent content) {
        if (content == null) {
            return false;
        }
        boolean handles = false;
        IProject project = content.getProject();
        IPath path = content.getPath();
        if (content.getContainerType() == ContainerType.Project) {
            handles = this.isFileInSourceFolder(project, path);
            if (content.getContent() instanceof IFile) {
                IFile file = (IFile)content.getContent();
                handles = handles && !this.isHiddenFileOrChildOfHidden(file);
            }
        } else if (content.getContainerType() == ContainerType.Jar) {
            handles = true;
        }
        return handles && this.doHandles(project, path);
    }

    protected abstract boolean doHandles(IProject var1, IPath var2);

    private boolean isFileInSourceFolder(IProject project, IPath path) {
        List<IResource> projectSourceDirectories = this.getProjectSourceDirectories(project);
        return projectSourceDirectories.stream().anyMatch(sourceFolder -> sourceFolder.getLocation().isPrefixOf(path));
    }

    private List<IResource> getProjectSourceDirectories(IProject project) {
        ArrayList<IResource> sourceDirectories = new ArrayList<IResource>();
        try {
            if (project.isOpen() && project.isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < classpathEntries.length) {
                    IClasspathEntry entry = classpathEntries[i];
                    if (entry.getContentKind() == 1) {
                        String relativePath = entry.getPath().toString();
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(relativePath);
                        if (resource != null) {
                            sourceDirectories.add(resource);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return sourceDirectories;
    }

    private boolean isHiddenFileOrChildOfHidden(IFile file) {
        if (file.isHidden()) {
            return true;
        }
        IContainer current = file.getParent();
        while (current != null) {
            if (current.getLocation().toFile().isHidden()) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }
}

