/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.explorer;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.mule.tooling.utils.Pair;

public abstract class ExplorerElementOrderProvider {
    public static final int PACKAGE_FRAGMENT_ROOT_INDEX = 50;
    public static final int PACKAGE_FRAGMENT_INDEX = 900;
    public static final int LIBRARY_CONTAINER_INDEX = 400;
    public static final int FOLDER_INDEX = 700;
    public static final int FILE_INDEX = 800;
    public static final int CLASSPATH_CONTAINER_INDEX = 500;
    private List<Pair<Predicate<Object>, Integer>> predicateExceptions = new LinkedList<Pair<Predicate<Object>, Integer>>();

    public ExplorerElementOrderProvider(List<Pair<Predicate<Object>, Integer>> predicateException) {
        this.predicateExceptions = predicateException;
    }

    public ExplorerElementOrderProvider() {
    }

    public abstract boolean handler(Object var1);

    protected abstract int getGenericOrder();

    public int getOrder(Object element) {
        for (Pair<Predicate<Object>, Integer> filter : this.predicateExceptions) {
            boolean matches = ((Predicate)filter.getLeft()).test(element);
            if (!matches) continue;
            return (Integer)filter.getRight();
        }
        return this.getGenericOrder();
    }
}

