/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.events;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.m2.MavenConfiguration;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.platform.component.IPlatformComponent;
import org.mule.tooling.platform.component.PlatformComponentManager;
import org.mule.tooling.platform.events.IEventListenerHandler;
import org.mule.tooling.platform.events.IProjectEventListener;
import org.mule.tooling.platform.utils.ProjectHelper;
import org.mule.tooling.platform.utils.SafeRunner;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class ProjectEventManager
implements IPlatformComponent,
IResourceChangeListener,
IElementChangedListener {
    public static final String DOT_PROJECT = ".project";
    private List<ProjectEventListenerExtension> listeners;
    private List<IProject> createdWaitingToOpen = new ArrayList<IProject>();

    public static ProjectEventManager getInstance() {
        return PlatformComponentManager.getPlatformComponent(ProjectEventManager.class).get();
    }

    public ProjectEventManager() {
        this.listeners = new ArrayList<ProjectEventListenerExtension>(this.loadExtensions());
    }

    protected List<ProjectEventListenerExtension> loadExtensions() {
        return IExtensionPointReader.create(ProjectEventListenerExtension.class).readAll();
    }

    public IEventListenerHandler addListener(String natureId, IProjectEventListener listener) {
        ProjectEventListenerExtension extension = new ProjectEventListenerExtension(listener, natureId, null);
        this.listeners.add(extension);
        return new ProjectEventListenerHandler(extension);
    }

    public IEventListenerHandler addListener(IProject project, IProjectEventListener listener) {
        ProjectEventListenerExtension extension = new ProjectEventListenerExtension(listener, null, project);
        this.listeners.add(extension);
        return new ProjectEventListenerHandler(extension);
    }

    public IEventListenerHandler addListener(IProjectEventListener listener) {
        return this.addListener((String)null, listener);
    }

    public void removeListener(String natureId, IProjectEventListener listener) {
        this.listeners.remove(new ProjectEventListenerExtension(listener, natureId, null));
    }

    public void removeListeners(IProject natureId) {
        List<ProjectEventListenerExtension> listenersForFireEvent = this.getListenersForFireEvent();
        for (ProjectEventListenerExtension listener : listenersForFireEvent) {
            if (!listener.getProject().isPresent() || listener.getProject().get() != natureId) continue;
            this.listeners.remove(listener);
        }
    }

    private boolean hasFlag(IJavaElementDelta delta, int flag) {
        return (delta.getFlags() & flag) != 0;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        this.processDelta(delta);
    }

    private void processDelta(IJavaElementDelta delta) {
        if (this.hasFlag(delta, 2228672)) {
            IJavaElement changedElement = delta.getElement();
            if (changedElement.getJavaProject() instanceof IJavaProject) {
                IProject project = changedElement.getJavaProject().getProject();
                IJavaElementDelta[] deltas = delta.getAffectedChildren();
                this.fireClasspathChangeEvent(delta, project);
                int i = 0;
                while (i < deltas.length) {
                    this.fireClasspathChangeEvent(deltas[i], project);
                    ++i;
                }
            }
        } else if (this.hasFlag(delta, 8)) {
            this.processChildren(delta);
        }
    }

    private void processChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            this.processDelta(childDelta);
            ++n2;
        }
    }

    private void fireClasspathChangeEvent(IJavaElementDelta delta, IProject project) {
        Path m2repoPath = new Path(MavenConfiguration.instance().getLocalRepositoryPath());
        IPackageFragmentRoot affectedJar = (IPackageFragmentRoot)delta.getElement().getAdapter(IPackageFragmentRoot.class);
        if (affectedJar != null && m2repoPath.isPrefixOf(affectedJar.getPath())) {
            File jarFile = affectedJar.getPath().toFile();
            if (delta.getKind() == 1 || this.hasFlag(delta, 2228544)) {
                MavenDependency dependencyFromPath = MavenUtils.getDependencyFromPath((File)jarFile);
                this.fireProjectClasspathEntryAdded(project, affectedJar, dependencyFromPath);
            } else if (this.hasFlag(delta, 128)) {
                MavenDependency dependencyFromPath = MavenUtils.getDependencyFromPath((File)jarFile);
                this.fireProjectClasspathEntryRemoved(project, affectedJar, dependencyFromPath);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        SafeRunner.exec(() -> {
            int eventType = event.getType();
            IResource resource = event.getResource();
            IResourceDelta delta = event.getDelta();
            switch (eventType) {
                case 8: 
                case 32: {
                    break;
                }
                case 2: {
                    if (!(resource instanceof IProject)) break;
                    this.fireProjectClosed(resource);
                    break;
                }
                case 4: {
                    if (!(resource instanceof IProject)) break;
                    this.fireProjectClosed(resource);
                    this.fireProjectRemoved(resource);
                    break;
                }
                case 1: {
                    if (delta == null) break;
                    delta.accept((IResourceDeltaVisitor)new ResourceChangedVisitor());
                }
            }
        }, "Listen on project event");
    }

    @Override
    public void wire() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    @Override
    public void start() {
        IProject[] projects;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                SafeRunner.exec(() -> this.fireProjectOpened(project), "Fire project Open");
            }
            ++n2;
        }
    }

    @Override
    public void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    private void fireProjectOpened(IProject project) throws CoreException {
        if (project.isAccessible()) {
            if (this.createdWaitingToOpen.contains(project)) {
                this.fireProjectCreated(project);
                this.createdWaitingToOpen.remove(project);
            }
            for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
                if (!this.isAcceptedBy(project, listenerExtension)) continue;
                listenerExtension.getListener().onProjectOpened(project);
            }
        }
    }

    private List<ProjectEventListenerExtension> getListenersForFireEvent() {
        return new ArrayList<ProjectEventListenerExtension>(this.listeners);
    }

    public void fireProjectClasspathEntryRemoved(IProject project, IPackageFragmentRoot affectedJar, MavenDependency dependency) {
        for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
            SafeRunner.exec(() -> {
                if (this.isAcceptedBy(project, listenerExtension)) {
                    listenerExtension.getListener().onClasspathEntryRemoved(project, affectedJar, dependency);
                }
            }, "Triggering classpath entry removed");
        }
    }

    public void fireProjectClasspathEntryAdded(IProject project, IPackageFragmentRoot affectedJar, MavenDependency dependency) {
        for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
            SafeRunner.exec(() -> {
                if (this.isAcceptedBy(project, listenerExtension)) {
                    listenerExtension.getListener().onClasspathEntryAdded(project, affectedJar, dependency);
                }
            }, "Triggering classpath entry added");
        }
    }

    public void fireProjectCreated(IProject project) throws CoreException {
        for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
            if (!this.isAcceptedBy(project, listenerExtension)) continue;
            listenerExtension.getListener().onProjectCreated(project);
        }
    }

    private void fireFileChanged(IProject project, IFile file) throws CoreException {
        for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
            if (!this.isAcceptedBy(project, listenerExtension)) continue;
            listenerExtension.getListener().onFileChanged(project, file);
        }
    }

    private void fireFileAdded(IProject project, IFile file) throws CoreException {
        for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
            if (!this.isAcceptedBy(project, listenerExtension)) continue;
            listenerExtension.getListener().onFileAdded(project, file);
        }
    }

    private void fireFileRemoved(IProject project, IFile file) throws CoreException {
        for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
            if (!this.isAcceptedBy(project, listenerExtension)) continue;
            listenerExtension.getListener().onFileRemoved(project, file);
        }
    }

    private void fireProjectClosed(IResource resource) throws CoreException {
        IProject project = (IProject)resource;
        for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
            if (!this.isAcceptedBy(project, listenerExtension)) continue;
            listenerExtension.getListener().onProjectClosed(project);
        }
    }

    private void fireProjectRemoved(IResource resource) throws CoreException {
        IProject project = (IProject)resource;
        for (ProjectEventListenerExtension listenerExtension : this.getListenersForFireEvent()) {
            if (!this.isAcceptedBy(project, listenerExtension)) continue;
            listenerExtension.getListener().onProjectRemoved(project);
        }
        this.removeListeners(project);
    }

    private boolean isAcceptedBy(IProject project, ProjectEventListenerExtension listenerExtension) throws CoreException {
        Optional<IProject> filterProject = listenerExtension.getProject();
        if (filterProject.isPresent()) {
            return filterProject.get().equals((Object)project);
        }
        Optional<String> natureId = listenerExtension.getNatureId();
        if (natureId.isPresent()) {
            return ProjectHelper.hasNature(project, natureId.get());
        }
        return true;
    }

    private static boolean hasFlag(IResourceDelta delta, int flag) {
        return (delta.getFlags() & flag) != 0;
    }

    @ExtensionPoint(extensionPointId="org.mule.events.projectEvents")
    public static class ProjectEventListenerExtension {
        @ExtensionAttribute(attributeName="class")
        private IProjectEventListener listener;
        @ExtensionAttribute(attributeName="natureId", optional=true)
        private String natureId;
        private IProject project;

        public ProjectEventListenerExtension(IProjectEventListener listener, String natureId, IProject project) {
            this.listener = listener;
            this.natureId = natureId;
            this.project = project;
        }

        public ProjectEventListenerExtension() {
        }

        public IProjectEventListener getListener() {
            return this.listener;
        }

        public void setListener(IProjectEventListener listener) {
            this.listener = listener;
        }

        public Optional<String> getNatureId() {
            return Optional.ofNullable(this.natureId);
        }

        public void setNatureId(String natureId) {
            this.natureId = natureId;
        }

        public Optional<IProject> getProject() {
            return Optional.ofNullable(this.project);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            result = 31 * result + (this.natureId == null ? 0 : this.natureId.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectEventListenerExtension other = (ProjectEventListenerExtension)obj;
            if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
                return false;
            }
            if (this.natureId == null ? other.natureId != null : !this.natureId.equals(other.natureId)) {
                return false;
            }
            return !(this.project == null ? other.project != null : !this.project.equals((Object)other.project));
        }
    }

    private final class ProjectEventListenerHandler
    implements IEventListenerHandler {
        private final ProjectEventListenerExtension extension;

        private ProjectEventListenerHandler(ProjectEventListenerExtension extension) {
            this.extension = extension;
        }

        @Override
        public void unregister() {
            ProjectEventManager.this.listeners.remove(this.extension);
        }
    }

    private final class ResourceChangedVisitor
    implements IResourceDeltaVisitor {
        private ResourceChangedVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IFile file;
            IProject project;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project2 = (IProject)resource;
                if (delta.getKind() == 1) {
                    ProjectEventManager.this.createdWaitingToOpen.add(project2);
                } else if ((delta.getFlags() & 0x4000) != 0) {
                    ProjectEventManager.this.fireProjectOpened(project2);
                }
            } else if (resource instanceof IFile && (project = (file = (IFile)resource).getProject()) != null) {
                switch (delta.getKind()) {
                    case 1: {
                        if (ProjectEventManager.DOT_PROJECT.equals(file.getName())) {
                            ProjectEventManager.this.fireProjectOpened(project);
                            break;
                        }
                        ProjectEventManager.this.fireFileAdded(project, file);
                        break;
                    }
                    case 2: {
                        if (ProjectEventManager.DOT_PROJECT.equals(file.getName())) {
                            ProjectEventManager.this.fireProjectClosed((IResource)project);
                            break;
                        }
                        ProjectEventManager.this.fireFileRemoved(project, file);
                        break;
                    }
                    case 4: {
                        if (!ProjectEventManager.hasFlag(delta, 256)) break;
                        ProjectEventManager.this.fireFileChanged(project, file);
                    }
                }
            }
            return true;
        }
    }
}

