/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.dependencymanagement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.dependencymanagement.EclipseDependencyManager;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.platform.PlatformPlugin;
import org.mule.tooling.platform.builder.events.BuilderEvents;
import org.mule.tooling.platform.builder.events.DependencyRemovedEvent;
import org.mule.tooling.platform.component.IPlatformComponent;
import org.mule.tooling.platform.component.PlatformComponentManager;
import org.mule.tooling.platform.dependencymanagement.DependencyManagementLock;
import org.mule.tooling.platform.dependencymanagement.FileBasedDependencyManagerFactory;
import org.mule.tooling.platform.dependencymanagement.IDependencyModel;
import org.mule.tooling.platform.dependencymanagement.IDependencyModelManager;
import org.mule.tooling.platform.dependencymanagement.IDependencyModelManagerFactory;
import org.mule.tooling.platform.dependencymanagement.IDependencyModelMutator;
import org.mule.tooling.platform.dependencymanagement.IFileBasedDependencyModelProvider;
import org.mule.tooling.platform.dependencymanagement.MavenDependencyClasspathContainer;
import org.mule.tooling.platform.events.DefaultProjectEventListener;
import org.mule.tooling.platform.events.IEventListenerHandler;
import org.mule.tooling.platform.events.IProjectEventListener;
import org.mule.tooling.platform.events.ProjectEventManager;
import org.mule.tooling.platform.locking.LockingService;
import org.mule.tooling.platform.utils.ProjectHelper;
import org.mule.tooling.platform.utils.SafeRunner;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class ProjectDependecyManager
extends DefaultProjectEventListener
implements IPlatformComponent {
    private List<Pair<String, IDependencyModelManagerFactory>> factoriesByNature;
    private HashMap<IProject, DependencyEntry> models = new HashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private List<IEventListenerHandler> listeners;
    private EventBusHelper eventBusHelper = new EventBusHelper();
    private List<MavenDependency> updatingDep = new ArrayList<MavenDependency>();

    public static ProjectDependecyManager getInstance() {
        return PlatformComponentManager.getPlatformComponent(ProjectDependecyManager.class).get();
    }

    ProjectDependecyManager() {
        this.factoriesByNature = this.loadExtensions().stream().map(extension -> {
            IFileBasedDependencyModelProvider fileDepManager = extension.getFileModelProvider();
            IDependencyModelManagerFactory depManager = fileDepManager != null ? new FileBasedDependencyManagerFactory(fileDepManager) : extension.getFactory();
            return new Pair((Object)extension.getNatureId(), (Object)depManager);
        }).collect(Collectors.toList());
    }

    public Optional<IDependencyModel> getDependencyModel(IProject project) {
        return this.getOrCreateModel(project);
    }

    public Optional<IDependencyModel> reloadAndGetDependencyModel(IProject project) {
        return this.reloadModel(project);
    }

    public List<IProject> filterProjectWith(Predicate<IDependencyModel> criteria) {
        this.lock.readLock().lock();
        try {
            List<IProject> list = this.models.entrySet().stream().filter(pair -> criteria.test(((DependencyEntry)pair.getValue()).getModel())).map(Map.Entry::getKey).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<IProject> findProjectWith(Predicate<IDependencyModel> criteria) {
        this.lock.readLock().lock();
        try {
            Optional<IProject> optional = this.models.entrySet().stream().filter(pair -> criteria.test(((DependencyEntry)pair.getValue()).getModel())).map(Map.Entry::getKey).findFirst();
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<IDependencyModel> reloadModel(IProject project) {
        this.removeProjectFromModelContainer(project);
        return this.getOrCreateModel(project);
    }

    protected List<DependecyManagerExtension> loadExtensions() {
        return IExtensionPointReader.create(DependecyManagerExtension.class).readAll();
    }

    @Override
    public void start() {
    }

    @Override
    public void wire() {
        this.initListeners();
        this.registerEventBus();
    }

    private void registerEventBus() {
        this.eventBusHelper.registerListener(PlatformPlugin.getEventBus(), BuilderEvents.ON_ARTIFACTS_BUILT, deps -> {
            List<IProject> projectNeedUpdate = this.filterProjectWith(m -> {
                for (MavenDependency mavenDependency : deps) {
                    if (!m.getDependencies().contains(mavenDependency)) continue;
                    return true;
                }
                return false;
            });
            for (IProject project : projectNeedUpdate) {
                DependencyEntry model = this.getEntry(project);
                List<MavenDependency> dependencies = model.getModel().getDependencies();
                List<MavenDependency> toUpdate = deps.stream().filter(d -> dependencies.contains(d)).collect(Collectors.toList());
                this.refreshDependency(project, toUpdate);
            }
        });
    }

    private void initListeners() {
        this.listeners = this.factoriesByNature.stream().map(entry -> ProjectEventManager.getInstance().addListener((String)entry.getLeft(), (IProjectEventListener)new DefaultProjectEventListener(){

            @Override
            public void onProjectOpened(IProject project) {
                ProjectDependecyManager.this.initProjectDependencyManager(project);
            }

            @Override
            public void onProjectClosed(IProject project) {
                ProjectDependecyManager.this.removeProjectFromModelContainer(project);
            }

            @Override
            public void onClasspathEntryRemoved(IProject project, IPackageFragmentRoot affectedJar, final MavenDependency entry) {
                if (ProjectDependecyManager.this.updatingDep.contains(entry)) {
                    return;
                }
                final Optional<IDependencyModelMutator> mutator = ProjectDependecyManager.this.getEntry(project).getProvider().mutator();
                if (!mutator.isPresent()) {
                    return;
                }
                Job job = new Job("Removing dependency " + String.valueOf(entry)){

                    protected IStatus run(IProgressMonitor monitor) {
                        boolean modified = ((IDependencyModelMutator)mutator.get()).removeDependency(entry);
                        if (modified) {
                            ((IDependencyModelMutator)mutator.get()).persist(monitor);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        })).collect(Collectors.toList());
    }

    public final IDependencyModelManager getDependencyModelManager(IProject project) {
        return this.getEntry(project).getProvider();
    }

    public void addDependencyEntryToProject(IProject project, IDependencyModelManagerFactory factory) {
        DependencyEntry entry = this.createEntry(project, factory);
        this.models.put(project, entry);
    }

    @Override
    public void stop() {
        this.lock.readLock().lock();
        try {
            this.models.entrySet().forEach(extension -> ((DependencyEntry)extension.getValue()).getProvider().stop());
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.listeners.forEach(IEventListenerHandler::unregister);
        this.eventBusHelper.unregister();
    }

    private DependencyEntry createEntry(IProject project, IDependencyModelManagerFactory factory) {
        IDependencyModelManager manager = factory.create(project);
        manager.setDepedencyManagerModificationListener(model -> this.handleModelChanged((IProgressMonitor)new NullProgressMonitor(), project, model));
        IDependencyModel model2 = manager.loadModel();
        return new DependencyEntry(model2, manager);
    }

    private void handleModelChanged(IProgressMonitor monitor, IProject project, IDependencyModel newModel) {
        DependencyEntry depEntry = this.getEntry(project);
        if (depEntry != null) {
            DependencyChanges calculateDelta = this.calculateDelta(newModel, depEntry.getModel());
            if (calculateDelta.changed()) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                depEntry.setModel(newModel);
                List<MavenDependency> newLibraries = calculateDelta.getNewLibraries();
                this.addDependenciesToProject(javaProject, newLibraries, monitor);
                List<MavenDependency> removedLibraries = calculateDelta.getRemovedLibraries();
                this.removeDependenciesFromProject(javaProject, removedLibraries, monitor);
            } else {
                depEntry.setModel(newModel);
            }
        }
    }

    private DependencyEntry getEntry(IProject project) {
        this.lock.readLock().lock();
        try {
            DependencyEntry dependencyEntry = this.models.get(project);
            return dependencyEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Optional<IDependencyModel> getOrCreateModel(IProject project) {
        if (this.models.containsKey(project)) {
            return Optional.ofNullable(this.getEntry(project)).map(DependencyEntry::getModel);
        }
        Optional<Pair> findFirst = this.factoriesByNature.stream().filter(pair -> ProjectHelper.hasNature(project, (String)pair.getLeft())).findFirst();
        if (findFirst.isPresent()) {
            this.lock.writeLock().lock();
            try {
                if (this.models.containsKey(project)) {
                    Optional<IDependencyModel> optional = Optional.of(this.getEntry(project).getModel());
                    return optional;
                }
                DependencyEntry createEntry = this.createEntry(project, (IDependencyModelManagerFactory)findFirst.get().getRight());
                this.models.put(project, createEntry);
                createEntry.getProvider().wire();
                createEntry.getProvider().start();
                Optional<IDependencyModel> optional = Optional.of(createEntry.getModel());
                return optional;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return Optional.empty();
    }

    @Override
    public void onProjectCreated(IProject project) {
    }

    @Override
    public void onProjectClosed(IProject project) {
    }

    public void refreshDependency(IProject project, final List<MavenDependency> deps) {
        final IJavaProject javaProject = JavaCore.create((IProject)project);
        new Job("Updating dependencies on " + project.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                for (MavenDependency mavenDependency : deps) {
                    ProjectDependecyManager.this.updatingDep.add(mavenDependency);
                    ProjectDependecyManager.this.removeDependenciesFromProject(javaProject, Collections.singletonList(mavenDependency), monitor);
                    ProjectDependecyManager.this.addDependenciesToProject(javaProject, Collections.singletonList(mavenDependency), monitor);
                    ProjectDependecyManager.this.updatingDep.remove(mavenDependency);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void removeDependenciesFromProject(IJavaProject javaProject, List<MavenDependency> removedLibraries, IProgressMonitor monitor) {
        EclipseDependencyManager eclipseDependencyManager = new EclipseDependencyManager();
        for (MavenDependency mavenDependency : removedLibraries) {
            PlatformPlugin.getEventBus().fireEvent((IEvent)new DependencyRemovedEvent(Arrays.asList(mavenDependency), javaProject.getProject()));
            IClasspathEntry varEntry = JavaCore.newContainerEntry((IPath)MavenDependencyClasspathContainer.getContainerPath(mavenDependency), (boolean)false);
            SafeRunner.exec(() -> eclipseDependencyManager.removeEntryFromClasspath(varEntry, javaProject, monitor), "Removing classpath entry `" + varEntry.getPath().toOSString() + "`");
        }
    }

    private void addDependenciesToProject(IJavaProject javaProject, List<MavenDependency> newLibraries, IProgressMonitor monitor) {
        EclipseDependencyManager eclipseDependencyManager = new EclipseDependencyManager();
        for (MavenDependency mavenDependency : newLibraries) {
            MavenDependencyClasspathContainer entry = new MavenDependencyClasspathContainer(mavenDependency);
            SafeRunner.exec(() -> eclipseDependencyManager.addEntryToClasspath((IClasspathContainer)entry, javaProject, monitor), "Adding classpath entry `" + entry.getPath().toOSString() + "`");
        }
    }

    private DependencyChanges calculateDelta(IDependencyModel newModel, IDependencyModel oldModel) {
        List<MavenDependency> newDependencies = newModel.getDependencies();
        List<MavenDependency> oldDependencies = oldModel.getDependencies();
        return this.calculateDelta(newDependencies, oldDependencies);
    }

    private DependencyChanges calculateDelta(List<MavenDependency> newDependencies, List<MavenDependency> oldDependencies) {
        ArrayList<MavenDependency> newLibraries = new ArrayList<MavenDependency>();
        for (MavenDependency newDep : newDependencies) {
            if (oldDependencies.contains(newDep)) continue;
            newLibraries.add(newDep);
        }
        ArrayList<MavenDependency> removedLibraries = new ArrayList<MavenDependency>();
        for (MavenDependency oldDep : oldDependencies) {
            if (newDependencies.contains(oldDep)) continue;
            removedLibraries.add(oldDep);
        }
        return new DependencyChanges(newLibraries, removedLibraries);
    }

    private void initProjectDependencyManager(IProject project) {
        Optional<IDependencyModel> model = this.getOrCreateModel(project);
        if (model.isPresent()) {
            LockingService.getInstance().schedule(project, DependencyManagementLock.getInstance(), monitor -> SafeRunner.exec(() -> {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                List<IClasspathEntry> classpathEntries = Arrays.asList(javaProject.getRawClasspath());
                List<IClasspathEntry> resolvedClasspathEntries = Arrays.asList(javaProject.getResolvedClasspath(true));
                List<MavenDependency> oldDependencies = classpathEntries.stream().filter(MavenDependencyClasspathContainer::isMavenDep).map(centry -> MavenDependencyClasspathContainer.fromPath(centry.getPath()).getDependency()).collect(Collectors.toList());
                DependencyChanges calculateDelta = this.calculateDelta(((IDependencyModel)model.get()).getDependencies(), oldDependencies);
                if (calculateDelta.changed()) {
                    List<MavenDependency> newLibraries = calculateDelta.getNewLibraries();
                    this.addDependenciesToProject(javaProject, newLibraries, monitor);
                    List<MavenDependency> removedLibraries = calculateDelta.getRemovedLibraries();
                    this.removeDependenciesFromProject(javaProject, removedLibraries, monitor);
                }
                if (!classpathEntries.equals(resolvedClasspathEntries)) {
                    classpathEntries.stream().filter(entry -> !resolvedClasspathEntries.contains(entry)).forEach(classpathEntry -> {
                        try {
                            ProjectClasspathUtils.reinitializeClasspathContainer((IJavaProject)javaProject, (IPath)classpathEntry.getPath());
                        }
                        catch (CoreException e) {
                            MuleCorePlugin.logError((String)"Could not resolve classpath container", (Throwable)e);
                        }
                    });
                }
            }, "Dependency Management Reconciler for: " + project.getName()), LockingService.LockType.WRITE, "Dependency Management Reconciler for: " + project.getName());
        }
    }

    private void removeProjectFromModelContainer(IProject project) {
        this.lock.writeLock().lock();
        try {
            DependencyEntry remove = this.models.remove(project);
            if (remove != null) {
                remove.getProvider().stop();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @ExtensionPoint(extensionPointId="org.mule.maven.dependencyManager")
    public static class DependecyManagerExtension {
        @ExtensionAttribute(attributeName="filemodel", optional=true)
        private IFileBasedDependencyModelProvider fileModelProvider;
        @ExtensionAttribute(attributeName="factory", optional=true)
        private IDependencyModelManagerFactory factory;
        @ExtensionAttribute(attributeName="natureId")
        private String natureId;

        public void setFileModelProvider(IFileBasedDependencyModelProvider fileModelProvider) {
            this.fileModelProvider = fileModelProvider;
        }

        public void setFactory(IDependencyModelManagerFactory factory) {
            this.factory = factory;
        }

        public IFileBasedDependencyModelProvider getFileModelProvider() {
            return this.fileModelProvider;
        }

        public IDependencyModelManagerFactory getFactory() {
            return this.factory;
        }

        public String getNatureId() {
            return this.natureId;
        }

        public void setNatureId(String natureId) {
            this.natureId = natureId;
        }
    }

    private static class DependencyChanges {
        private List<MavenDependency> newLibraries;
        private List<MavenDependency> removedLibraries;

        public DependencyChanges(List<MavenDependency> newLibraries, List<MavenDependency> removedLibraries) {
            this.newLibraries = newLibraries;
            this.removedLibraries = removedLibraries;
        }

        public List<MavenDependency> getNewLibraries() {
            return this.newLibraries;
        }

        public List<MavenDependency> getRemovedLibraries() {
            return this.removedLibraries;
        }

        public boolean changed() {
            return !this.removedLibraries.isEmpty() || !this.newLibraries.isEmpty();
        }
    }

    private static class DependencyEntry {
        private IDependencyModel model;
        private IDependencyModelManager provider;

        public DependencyEntry(IDependencyModel model, IDependencyModelManager provider) {
            this.model = model;
            this.provider = provider;
        }

        public void setModel(IDependencyModel model) {
            this.model = model;
        }

        public IDependencyModel getModel() {
            return this.model;
        }

        public IDependencyModelManager getProvider() {
            return this.provider;
        }
    }
}

