/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.dependencymanagement;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.mule.maven.client.internal.MuleMavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMavenRepositoriesProvider;
import org.mule.tooling.core.utils.ClasspathEntryUtils;
import org.mule.tooling.core.utils.MavenClientFactory;
import org.mule.tooling.platform.PlatformPlugin;
import org.mule.tooling.platform.dependencymanagement.IDependencyModel;
import org.mule.tooling.platform.dependencymanagement.MavenDependencyClasspathContainer;
import org.mule.tooling.platform.dependencymanagement.ProjectDependecyManager;

public class MavenDependencyClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        Optional<IDependencyModel> dependencyModel = ProjectDependecyManager.getInstance().getDependencyModel(project.getProject());
        MavenDependencyClasspathContainer fromPath = MavenDependencyClasspathContainer.fromPath(containerPath);
        BundleDescriptor bundle = MavenUtils.getBundleDescriptor((MavenCoordinates)fromPath.getDependency());
        if (dependencyModel.isPresent()) {
            MuleMavenClient mavenClient = MavenClientFactory.getMavenClient((IMavenRepositoriesProvider)dependencyModel.get());
            try {
                BundleDependency resolveBundleDescriptor = mavenClient.resolveBundleDescriptor(bundle);
                List deps = mavenClient.resolveBundleDescriptorDependencies(false, bundle);
                ArrayList<BundleDependency> allEntries = new ArrayList<BundleDependency>(deps);
                allEntries.add(resolveBundleDescriptor);
                IClasspathEntry[] entries = (IClasspathEntry[])allEntries.stream().map(dependency -> JavaCore.newLibraryEntry((IPath)URIUtil.toPath((URI)dependency.getBundleUri()), null, null)).toArray(IClasspathEntry[]::new);
                MavenDependencyClasspathContainer container = new MavenDependencyClasspathContainer(fromPath.getDependency(), entries);
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            }
            catch (Exception exception) {
                String m2repoPath = MavenCore.getM2repoPath();
                String name = bundle.getArtifactId() + "-" + bundle.getVersion();
                if (bundle.getClassifier().isPresent()) {
                    name = name + "-" + (String)bundle.getClassifier().get();
                }
                name = name + "." + bundle.getType();
                String groupId = bundle.getGroupId().replace('.', File.separatorChar);
                File localUrl = new File(m2repoPath, groupId + File.separator + bundle.getArtifactId() + File.separator + bundle.getVersion() + File.separator + name);
                IClasspathEntry newLibraryEntry = ClasspathEntryUtils.newLibraryEntryWithNoSourceAttachment((IPath)URIUtil.toPath((URI)localUrl.toURI()));
                MavenDependencyClasspathContainer container = new MavenDependencyClasspathContainer(fromPath.getDependency(), new IClasspathEntry[]{newLibraryEntry});
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            }
        } else {
            PlatformPlugin.logError("No dependency model found :(. Classpath container is not going to be initialized." + containerPath.toOSString());
        }
    }

    public IClasspathContainer getFailureContainer(IPath containerPath, IJavaProject project) {
        return null;
    }
}

