/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.dependencymanagement;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;

public class MavenDependencyClasspathContainer
implements IClasspathContainer {
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    private static final String REGEX = ":";
    public static final String MAVEN_DEP_LIB = "MAVEN_DEP_LIB";
    private final IClasspathEntry[] entries;
    private MavenDependency dependency;
    private String description;
    private String version;

    public MavenDependencyClasspathContainer(MavenDependency dependency) {
        this(dependency, new IClasspathEntry[0]);
    }

    public MavenDependencyClasspathContainer(MavenDependency dependency, IClasspathEntry[] entries) {
        this(dependency, entries, dependency.getArtifactId());
    }

    public MavenDependencyClasspathContainer(MavenDependency dependency, IClasspathEntry[] entries, String name) {
        this.dependency = dependency;
        this.description = name;
        this.version = dependency.getVersion();
        this.entries = entries;
    }

    public IClasspathEntry[] getEntries() {
        return this.entries;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entries;
    }

    public String getDescription() {
        return this.description + " [v" + this.version + "] ";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return MavenDependencyClasspathContainer.getContainerPath(MavenDependencyClasspathContainer.toMavenCoords(this.dependency));
    }

    public static String toMavenCoords(MavenDependency dependency) {
        String versionString = dependency.getGroupId() + REGEX + dependency.getArtifactId() + REGEX + dependency.getVersion();
        versionString = dependency.getType().isPresent() ? versionString + REGEX + (String)dependency.getType().get() : versionString + ":jar";
        if (dependency.getClassifier().isPresent()) {
            versionString = versionString + REGEX + (String)dependency.getClassifier().get();
        }
        return versionString;
    }

    public static IPath getContainerPath(MavenDependency mavenDep) {
        return MavenDependencyClasspathContainer.getContainerPath(MavenDependencyClasspathContainer.toMavenCoords(mavenDep));
    }

    public static IPath getContainerPath(String name) {
        return new Path("MAVEN_DEP_LIB/" + MavenDependencyClasspathContainer.getContainerPathQualifier(name));
    }

    private static String getContainerPathQualifier(String name) {
        return name.replaceAll(REGEX, PATH_SEPARATOR);
    }

    public static boolean isMavenDep(IClasspathEntry entry) {
        IPath path = entry.getPath();
        return MavenDependencyClasspathContainer.isMavenDep(path);
    }

    public static boolean isMavenDep(IPath path) {
        return path != null && path.segmentCount() > 0 && MAVEN_DEP_LIB.equals(path.segment(0));
    }

    public static MavenDependencyClasspathContainer fromPath(IPath containerPath) {
        String[] segments = containerPath.removeFirstSegments(1).segments();
        return new MavenDependencyClasspathContainer(MavenDependencyClasspathContainer.createMavenDependency(segments));
    }

    private static MavenDependency createMavenDependency(String ... segments) {
        PojoMavenDependencyBuilder builder = (PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(segments[0])).withArtifactId(segments[1])).withVersion(segments[2])).withType(segments[3]);
        if (segments.length == 5) {
            builder.withClassifier(segments[4]);
        }
        return builder.build();
    }

    public MavenDependency getDependency() {
        return this.dependency;
    }
}

