/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.dependencymanagement;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.platform.dependencymanagement.DependencyManagerMessage;
import org.mule.tooling.platform.dependencymanagement.DependencyManagerMessageCollector;
import org.mule.tooling.platform.dependencymanagement.IDependecyModelChangedListener;
import org.mule.tooling.platform.dependencymanagement.IDependencyModel;
import org.mule.tooling.platform.dependencymanagement.IDependencyModelManager;
import org.mule.tooling.platform.dependencymanagement.IDependencyModelMutator;
import org.mule.tooling.platform.dependencymanagement.IFileBasedDependencyModelProvider;
import org.mule.tooling.platform.events.DefaultProjectEventListener;
import org.mule.tooling.platform.events.IEventListenerHandler;
import org.mule.tooling.platform.events.IProjectEventListener;
import org.mule.tooling.platform.events.ProjectEventManager;
import org.mule.tooling.platform.utils.ProjectHelper;
import org.mule.tooling.platform.utils.SafeRunner;

public class FileBasedDependencyManager
extends DefaultProjectEventListener
implements IDependencyModelManager {
    private static final String MARKER_ID = "org.mule.tooling.platform.dependencymanager.problemmarker";
    private IProject project;
    private IFileBasedDependencyModelProvider fileModelProvider;
    private IDependecyModelChangedListener listener;
    private IEventListenerHandler listenerHandler;

    public FileBasedDependencyManager(IProject project, IFileBasedDependencyModelProvider fileDepManager) {
        this.project = project;
        this.fileModelProvider = fileDepManager;
    }

    @Override
    public void wire() {
        this.listenerHandler = ProjectEventManager.getInstance().addListener(this.project, (IProjectEventListener)this);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.listenerHandler.unregister();
    }

    @Override
    public Optional<IDependencyModelMutator> mutator() {
        return this.fileModelProvider.mutator(this.getDepedencyManagerFile());
    }

    @Override
    public IDependencyModel loadModel() {
        DependencyManagerMessageCollector collector = new DependencyManagerMessageCollector();
        IDependencyModel result = this.fileModelProvider.loadModel(this.getDepedencyManagerFile(), collector);
        return result;
    }

    @Override
    public void setDepedencyManagerModificationListener(IDependecyModelChangedListener listener) {
        this.listener = listener;
    }

    @Override
    public void onFileAdded(IProject project, IFile file) {
        this.onFileChanged(project, file);
    }

    @Override
    public void onFileRemoved(IProject project, IFile file) {
        this.onFileChanged(project, file);
    }

    @Override
    public void onFileChanged(final IProject project, final IFile file) {
        if (ProjectHelper.isJavaProject(project) && this.getDepedencyManagerFile().getLocation().equals((Object)file.getLocation())) {
            Job dependencyJob = new Job(this.getJobName()){

                protected IStatus run(IProgressMonitor monitor) {
                    return SafeRunner.exec(() -> {
                        DependencyManagerMessageCollector messages = new DependencyManagerMessageCollector();
                        IDependencyModel newModel = FileBasedDependencyManager.this.fileModelProvider.loadModel(FileBasedDependencyManager.this.getDepedencyManagerFile(), messages);
                        FileBasedDependencyManager.this.listener.onModelChanged(newModel);
                        FileBasedDependencyManager.this.reportMessages(project, FileBasedDependencyManager.this.getDepedencyManagerFile(), messages);
                    }, "Updating Dependencies from `" + file.getLocation().toOSString() + "`");
                }
            };
            dependencyJob.schedule();
        }
    }

    private String getJobName() {
        return "Dependency Manager for " + this.project.getName();
    }

    private void reportMessages(final IProject project, final IFile file, final DependencyManagerMessageCollector messages) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (project.isAccessible()) {
                    project.deleteMarkers(FileBasedDependencyManager.MARKER_ID, true, 2);
                    List<DependencyManagerMessage> allMessages = messages.getMessages();
                    for (DependencyManagerMessage message : allMessages) {
                        IMarker createMarker = file.exists() ? file.createMarker(FileBasedDependencyManager.MARKER_ID) : project.createMarker(FileBasedDependencyManager.MARKER_ID);
                        createMarker.setAttribute("message", (Object)message.getMessage());
                        createMarker.setAttribute("charStart", message.getStartOffset());
                        createMarker.setAttribute("charEnd", message.getEndOffset());
                        createMarker.setAttribute("lineNumber", message.getLineNumber());
                        createMarker.setAttribute("severity", message.getSeverity());
                        Set<Map.Entry<String, Object>> entrySet = message.getAdditionalOptions().entrySet();
                        for (Map.Entry<String, Object> entry : entrySet) {
                            createMarker.setAttribute(entry.getKey(), entry.getValue());
                        }
                    }
                }
            }
        };
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        SafeRunner.exec(() -> workspace.run(runnable, null), "Reporting Dependency Manager Messages");
    }

    public IFile getDepedencyManagerFile() {
        return this.fileModelProvider.getDepedencyManagerFile(this.project);
    }
}

