/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.dependencymanagement;

import java.util.HashMap;
import java.util.Map;

public class DependencyManagerMessage {
    public static String PATH_PROPERTY = "PATH";
    private int severity;
    private String message;
    private int startOffset;
    private int endOffset;
    private int lineNumber;
    private Map<String, Object> additionalOptions;

    public DependencyManagerMessage(int severity, String message, int startOffset, int endOffset, int lineNumber) {
        this(severity, message, startOffset, endOffset, lineNumber, new HashMap<String, Object>());
    }

    public DependencyManagerMessage(int severity, String message, int startOffset, int endOffset, int lineNumber, Map<String, Object> additionalOptions) {
        this.severity = severity;
        this.message = message;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.lineNumber = lineNumber;
        this.additionalOptions = additionalOptions;
    }

    public Map<String, Object> getAdditionalOptions() {
        return this.additionalOptions;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public static DependencyManagerMessage dependencyFileDescriptorNotFound(String filePath) {
        HashMap<String, Object> additionalOptions = new HashMap<String, Object>();
        additionalOptions.put(PATH_PROPERTY, filePath);
        return new DependencyManagerMessage(2, "File: '" + filePath + "' was not found and is required for the dependency management.", 0, 0, 0, additionalOptions);
    }

    public static DependencyManagerMessage fromException(Exception e) {
        return new DependencyManagerMessage(2, e.getMessage(), 0, 0, 0, new HashMap<String, Object>());
    }
}

