/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.debug;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;

public class DebugTraceProvider {
    public static final String DEBUG = "/debug";
    private DebugTrace debugTrace;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;

    private DebugTraceProvider() {
    }

    public static DebugTraceProvider newRegisterdInstance(final BundleContext context, final String bundleID) {
        final DebugTraceProvider debugTracer = new DebugTraceProvider();
        debugTracer.registerDebugOptionsListener(context, bundleID);
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle().getSymbolicName().equals(bundleID) && 256 == event.getType()) {
                    context.removeBundleListener((BundleListener)this);
                    debugTracer.unregister();
                }
            }
        });
        return debugTracer;
    }

    private void registerDebugOptionsListener(BundleContext context, final String bundleID) {
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("listener.symbolic.name", bundleID);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)new DebugOptionsListener(){

            public void optionsChanged(DebugOptions options) {
                DebugTraceProvider.this.debugTrace = options.newDebugTrace(bundleID);
            }
        }, properties);
    }

    public void unregister() {
        this.debugRegistration.unregister();
        this.debugRegistration = null;
    }

    public DebugTrace debugTrace() {
        return this.debugTrace;
    }

    public static final String createDebugOptions(String option) {
        return DEBUG + (String)(option.startsWith("/") ? option : "/" + option);
    }
}

